% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_hyper_parameter_tuning_jobs}
\alias{sagemaker_list_hyper_parameter_tuning_jobs}
\title{Gets a list of HyperParameterTuningJobSummary objects that describe the
hyperparameter tuning jobs launched in your account}
\usage{
sagemaker_list_hyper_parameter_tuning_jobs(NextToken, MaxResults,
  SortBy, SortOrder, NameContains, CreationTimeAfter, CreationTimeBefore,
  LastModifiedTimeAfter, LastModifiedTimeBefore, StatusEquals)
}
\arguments{
\item{NextToken}{If the result of the previous \code{ListHyperParameterTuningJobs} request was
truncated, the response includes a \code{NextToken}. To retrieve the next set
of tuning jobs, use the token in the next request.}

\item{MaxResults}{The maximum number of tuning jobs to return. The default value is 10.}

\item{SortBy}{The field to sort results by. The default is \code{Name}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}

\item{NameContains}{A string in the tuning job name. This filter returns only tuning jobs
whose name contains the specified string.}

\item{CreationTimeAfter}{A filter that returns only tuning jobs that were created after the
specified time.}

\item{CreationTimeBefore}{A filter that returns only tuning jobs that were created before the
specified time.}

\item{LastModifiedTimeAfter}{A filter that returns only tuning jobs that were modified after the
specified time.}

\item{LastModifiedTimeBefore}{A filter that returns only tuning jobs that were modified before the
specified time.}

\item{StatusEquals}{A filter that returns only tuning jobs with the specified status.}
}
\description{
Gets a list of HyperParameterTuningJobSummary objects that describe the
hyperparameter tuning jobs launched in your account.
}
\section{Request syntax}{
\preformatted{svc$list_hyper_parameter_tuning_jobs(
  NextToken = "string",
  MaxResults = 123,
  SortBy = "Name"|"Status"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  NameContains = "string",
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping"
)
}
}

\keyword{internal}
