% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_put_access_control_rule}
\alias{workmail_put_access_control_rule}
\title{Adds a new access control rule for the specified organization}
\usage{
workmail_put_access_control_rule(
  Name,
  Effect,
  Description,
  IpRanges = NULL,
  NotIpRanges = NULL,
  Actions = NULL,
  NotActions = NULL,
  UserIds = NULL,
  NotUserIds = NULL,
  OrganizationId,
  ImpersonationRoleIds = NULL,
  NotImpersonationRoleIds = NULL
)
}
\arguments{
\item{Name}{[required] The rule name.}

\item{Effect}{[required] The rule effect.}

\item{Description}{[required] The rule description.}

\item{IpRanges}{IPv4 CIDR ranges to include in the rule.}

\item{NotIpRanges}{IPv4 CIDR ranges to exclude from the rule.}

\item{Actions}{Access protocol actions to include in the rule. Valid values include
\code{ActiveSync}, \code{AutoDiscover}, \code{EWS}, \code{IMAP}, \code{SMTP}, \code{WindowsOutlook},
and \code{WebMail}.}

\item{NotActions}{Access protocol actions to exclude from the rule. Valid values include
\code{ActiveSync}, \code{AutoDiscover}, \code{EWS}, \code{IMAP}, \code{SMTP}, \code{WindowsOutlook},
and \code{WebMail}.}

\item{UserIds}{User IDs to include in the rule.}

\item{NotUserIds}{User IDs to exclude from the rule.}

\item{OrganizationId}{[required] The identifier of the organization.}

\item{ImpersonationRoleIds}{Impersonation role IDs to include in the rule.}

\item{NotImpersonationRoleIds}{Impersonation role IDs to exclude from the rule.}
}
\description{
Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a new rule with the same name as an existing rule replaces the older rule.

See \url{https://www.paws-r-sdk.com/docs/workmail_put_access_control_rule/} for full documentation.
}
\keyword{internal}
