% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_associate_member_to_group}
\alias{workmail_associate_member_to_group}
\title{Adds a member (user or group) to the group's set}
\usage{
workmail_associate_member_to_group(OrganizationId, GroupId, MemberId)
}
\arguments{
\item{OrganizationId}{[required] The organization under which the group exists.}

\item{GroupId}{[required] The group to which the member (user or group) is associated.

The identifier can accept \emph{GroupId}, \emph{Groupname}, or \emph{email}. The
following identity formats are available:
\itemize{
\item Group ID: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: group@domain.tld
\item Group name: group
}}

\item{MemberId}{[required] The member (user or group) to associate to the group.

The member ID can accept \emph{UserID or GroupId}, \emph{Username or Groupname},
or \emph{email}.
\itemize{
\item Member: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: member@domain.tld
\item Member name: member
}}
}
\description{
Adds a member (user or group) to the group's set.

See \url{https://www.paws-r-sdk.com/docs/workmail_associate_member_to_group/} for full documentation.
}
\keyword{internal}
