% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_create_updated_workspace_image}
\alias{workspaces_create_updated_workspace_image}
\title{Creates a new updated WorkSpace image based on the specified source
image}
\usage{
workspaces_create_updated_workspace_image(
  Name,
  Description,
  SourceImageId,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the new updated WorkSpace image.}

\item{Description}{[required] A description of whether updates for the WorkSpace image are available.}

\item{SourceImageId}{[required] The identifier of the source WorkSpace image.}

\item{Tags}{The tags that you want to add to the new updated WorkSpace image.

To add tags at the same time when you're creating the updated image, you
must create an IAM policy that grants your IAM user permissions to use
\code{workspaces:CreateTags}.}
}
\description{
Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.

See \url{https://paws-r.github.io/docs/workspaces/create_updated_workspace_image.html} for full documentation.
}
\keyword{internal}
