% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_ip_groups}
\alias{workspaces_describe_ip_groups}
\title{Describes one or more of your IP access control groups}
\usage{
workspaces_describe_ip_groups(GroupIds, NextToken, MaxResults)
}
\arguments{
\item{GroupIds}{The identifiers of one or more IP access control groups.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}

\item{MaxResults}{The maximum number of items to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Result = list(
    list(
      groupId = "string",
      groupName = "string",
      groupDesc = "string",
      userRules = list(
        list(
          ipRule = "string",
          ruleDesc = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes one or more of your IP access control groups.
}
\section{Request syntax}{
\preformatted{svc$describe_ip_groups(
  GroupIds = list(
    "string"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
