% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_get_resources}
\alias{workdocs_get_resources}
\title{Retrieves a collection of resources, including folders and documents}
\usage{
workdocs_get_resources(AuthenticationToken, UserId, CollectionType,
  Limit, Marker)
}
\arguments{
\item{AuthenticationToken}{The Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{UserId}{The user ID for the resource collection. This is a required field for
accessing the API operation using IAM credentials.}

\item{CollectionType}{The collection type.}

\item{Limit}{The maximum number of resources to return.}

\item{Marker}{The marker for the next set of results. This marker was received from a
previous call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Folders = list(
    list(
      Id = "string",
      Name = "string",
      CreatorId = "string",
      ParentFolderId = "string",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ResourceState = "ACTIVE"|"RESTORING"|"RECYCLING"|"RECYCLED",
      Signature = "string",
      Labels = list(
        "string"
      ),
      Size = 123,
      LatestVersionSize = 123
    )
  ),
  Documents = list(
    list(
      Id = "string",
      CreatorId = "string",
      ParentFolderId = "string",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      LatestVersionMetadata = list(
        Id = "string",
        Name = "string",
        ContentType = "string",
        Size = 123,
        Signature = "string",
        Status = "INITIALIZED"|"ACTIVE",
        CreatedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        ModifiedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        ContentCreatedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        ContentModifiedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        CreatorId = "string",
        Thumbnail = list(
          "string"
        ),
        Source = list(
          "string"
        )
      ),
      ResourceState = "ACTIVE"|"RESTORING"|"RECYCLING"|"RECYCLED",
      Labels = list(
        "string"
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Retrieves a collection of resources, including folders and documents.
The only \code{CollectionType} supported is \code{SHARED_WITH_ME}.
}
\section{Request syntax}{
\preformatted{svc$get_resources(
  AuthenticationToken = "string",
  UserId = "string",
  CollectionType = "SHARED_WITH_ME",
  Limit = 123,
  Marker = "string"
)
}
}

\keyword{internal}
