% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_describe_document_versions}
\alias{workdocs_describe_document_versions}
\title{Retrieves the document versions for the specified document}
\usage{
workdocs_describe_document_versions(AuthenticationToken, DocumentId,
  Marker, Limit, Include, Fields)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{Limit}{The maximum number of versions to return with this call.}

\item{Include}{A comma-separated list of values. Specify "INITIALIZED" to include
incomplete versions.}

\item{Fields}{Specify "SOURCE" to include initialized versions and a URL for the
source document.}
}
\value{
A list with the following syntax:\preformatted{list(
  DocumentVersions = list(
    list(
      Id = "string",
      Name = "string",
      ContentType = "string",
      Size = 123,
      Signature = "string",
      Status = "INITIALIZED"|"ACTIVE",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ContentCreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ContentModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      CreatorId = "string",
      Thumbnail = list(
        "string"
      ),
      Source = list(
        "string"
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Retrieves the document versions for the specified document.

By default, only active versions are returned.
}
\section{Request syntax}{
\preformatted{svc$describe_document_versions(
  AuthenticationToken = "string",
  DocumentId = "string",
  Marker = "string",
  Limit = 123,
  Include = "string",
  Fields = "string"
)
}
}

\keyword{internal}
