% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_event_subscription}
\alias{rds_modify_event_subscription}
\title{Modifies an existing RDS event notification subscription}
\usage{
rds_modify_event_subscription(
  SubscriptionName,
  SnsTopicArn = NULL,
  SourceType = NULL,
  EventCategories = NULL,
  Enabled = NULL
)
}
\arguments{
\item{SubscriptionName}{[required] The name of the RDS event notification subscription.}

\item{SnsTopicArn}{The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you would set
this parameter to db-instance. For RDS Proxy events, specify \code{db-proxy}.
If this value isn't specified, all events are returned.

Valid
Values:\code{db-instance | db-cluster | db-parameter-group | db-security-group | db-snapshot | db-cluster-snapshot | db-proxy | zero-etl | custom-engine-version | blue-green-deployment}}

\item{EventCategories}{A list of event categories for a source type (\code{SourceType}) that you
want to subscribe to. You can see a list of the categories for a given
source type in
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html}{Events}
in the \emph{Amazon RDS User Guide} or by using the
\code{\link[=rds_describe_event_categories]{describe_event_categories}} operation.}

\item{Enabled}{Specifies whether to activate the subscription.}
}
\description{
Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this call. To change source identifiers for a subscription, use the \code{\link[=rds_add_source_identifier_to_subscription]{add_source_identifier_to_subscription}} and \code{\link[=rds_remove_source_identifier_from_subscription]{remove_source_identifier_from_subscription}} calls.

See \url{https://www.paws-r-sdk.com/docs/rds_modify_event_subscription/} for full documentation.
}
\keyword{internal}
