% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_increase_replica_count}
\alias{elasticache_increase_replica_count}
\title{Dynamically increases the number of replicas in a Redis OSS (cluster
mode disabled) replication group or the number of replica nodes in one
or more node groups (shards) of a Redis OSS (cluster mode enabled)
replication group}
\usage{
elasticache_increase_replica_count(
  ReplicationGroupId,
  NewReplicaCount = NULL,
  ReplicaConfiguration = NULL,
  ApplyImmediately
)
}
\arguments{
\item{ReplicationGroupId}{[required] The id of the replication group to which you want to add replica nodes.}

\item{NewReplicaCount}{The number of read replica nodes you want at the completion of this
operation. For Redis OSS (cluster mode disabled) replication groups,
this is the number of replica nodes in the replication group. For Redis
OSS (cluster mode enabled) replication groups, this is the number of
replica nodes in each of the replication group's node groups.}

\item{ReplicaConfiguration}{A list of \code{ConfigureShard} objects that can be used to configure each
shard in a Redis OSS (cluster mode enabled) replication group. The
\code{ConfigureShard} has three members: \code{NewReplicaCount}, \code{NodeGroupId},
and \code{PreferredAvailabilityZones}.}

\item{ApplyImmediately}{[required] If \code{True}, the number of replica nodes is increased immediately.
\code{ApplyImmediately=False} is not currently supported.}
}
\description{
Dynamically increases the number of replicas in a Redis OSS (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis OSS (cluster mode enabled) replication group. This operation is performed with no cluster down time.

See \url{https://www.paws-r-sdk.com/docs/elasticache_increase_replica_count/} for full documentation.
}
\keyword{internal}
