# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lakeformation_service.R
NULL

#' Attaches one or more LF-tags to an existing resource
#'
#' @description
#' Attaches one or more LF-tags to an existing resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_add_lf_tags_to_resource/](https://www.paws-r-sdk.com/docs/lakeformation_add_lf_tags_to_resource/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Resource &#91;required&#93; The database, table, or column resource to which to attach an LF-tag.
#' @param LFTags &#91;required&#93; The LF-tags to attach to the resource.
#'
#' @keywords internal
#'
#' @rdname lakeformation_add_lf_tags_to_resource
lakeformation_add_lf_tags_to_resource <- function(CatalogId = NULL, Resource, LFTags) {
  op <- new_operation(
    name = "AddLFTagsToResource",
    http_method = "POST",
    http_path = "/AddLFTagsToResource",
    paginator = list()
  )
  input <- .lakeformation$add_lf_tags_to_resource_input(CatalogId = CatalogId, Resource = Resource, LFTags = LFTags)
  output <- .lakeformation$add_lf_tags_to_resource_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$add_lf_tags_to_resource <- lakeformation_add_lf_tags_to_resource

#' Allows a caller to assume an IAM role decorated as the SAML user
#' specified in the SAML assertion included in the request
#'
#' @description
#' Allows a caller to assume an IAM role decorated as the SAML user specified in the SAML assertion included in the request. This decoration allows Lake Formation to enforce access policies against the SAML users and groups. This API operation requires SAML federation setup in the caller’s account as it can only be called with valid SAML assertions. Lake Formation does not scope down the permission of the assumed role. All permissions attached to the role via the SAML federation setup will be included in the role session.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_assume_decorated_role_with_saml/](https://www.paws-r-sdk.com/docs/lakeformation_assume_decorated_role_with_saml/) for full documentation.
#'
#' @param SAMLAssertion &#91;required&#93; A SAML assertion consisting of an assertion statement for the user who
#' needs temporary credentials. This must match the SAML assertion that was
#' issued to IAM. This must be Base64 encoded.
#' @param RoleArn &#91;required&#93; The role that represents an IAM principal whose scope down policy allows
#' it to call credential vending APIs such as
#' `GetTemporaryTableCredentials`. The caller must also have iam:PassRole
#' permission on this role.
#' @param PrincipalArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider in IAM that
#' describes the IdP.
#' @param DurationSeconds The time period, between 900 and 43,200 seconds, for the timeout of the
#' temporary credentials.
#'
#' @keywords internal
#'
#' @rdname lakeformation_assume_decorated_role_with_saml
lakeformation_assume_decorated_role_with_saml <- function(SAMLAssertion, RoleArn, PrincipalArn, DurationSeconds = NULL) {
  op <- new_operation(
    name = "AssumeDecoratedRoleWithSAML",
    http_method = "POST",
    http_path = "/AssumeDecoratedRoleWithSAML",
    paginator = list()
  )
  input <- .lakeformation$assume_decorated_role_with_saml_input(SAMLAssertion = SAMLAssertion, RoleArn = RoleArn, PrincipalArn = PrincipalArn, DurationSeconds = DurationSeconds)
  output <- .lakeformation$assume_decorated_role_with_saml_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$assume_decorated_role_with_saml <- lakeformation_assume_decorated_role_with_saml

#' Batch operation to grant permissions to the principal
#'
#' @description
#' Batch operation to grant permissions to the principal.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_batch_grant_permissions/](https://www.paws-r-sdk.com/docs/lakeformation_batch_grant_permissions/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Entries &#91;required&#93; A list of up to 20 entries for resource permissions to be granted by
#' batch operation to the principal.
#'
#' @keywords internal
#'
#' @rdname lakeformation_batch_grant_permissions
lakeformation_batch_grant_permissions <- function(CatalogId = NULL, Entries) {
  op <- new_operation(
    name = "BatchGrantPermissions",
    http_method = "POST",
    http_path = "/BatchGrantPermissions",
    paginator = list()
  )
  input <- .lakeformation$batch_grant_permissions_input(CatalogId = CatalogId, Entries = Entries)
  output <- .lakeformation$batch_grant_permissions_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$batch_grant_permissions <- lakeformation_batch_grant_permissions

#' Batch operation to revoke permissions from the principal
#'
#' @description
#' Batch operation to revoke permissions from the principal.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_batch_revoke_permissions/](https://www.paws-r-sdk.com/docs/lakeformation_batch_revoke_permissions/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Entries &#91;required&#93; A list of up to 20 entries for resource permissions to be revoked by
#' batch operation to the principal.
#'
#' @keywords internal
#'
#' @rdname lakeformation_batch_revoke_permissions
lakeformation_batch_revoke_permissions <- function(CatalogId = NULL, Entries) {
  op <- new_operation(
    name = "BatchRevokePermissions",
    http_method = "POST",
    http_path = "/BatchRevokePermissions",
    paginator = list()
  )
  input <- .lakeformation$batch_revoke_permissions_input(CatalogId = CatalogId, Entries = Entries)
  output <- .lakeformation$batch_revoke_permissions_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$batch_revoke_permissions <- lakeformation_batch_revoke_permissions

#' Attempts to cancel the specified transaction
#'
#' @description
#' Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_cancel_transaction/](https://www.paws-r-sdk.com/docs/lakeformation_cancel_transaction/) for full documentation.
#'
#' @param TransactionId &#91;required&#93; The transaction to cancel.
#'
#' @keywords internal
#'
#' @rdname lakeformation_cancel_transaction
lakeformation_cancel_transaction <- function(TransactionId) {
  op <- new_operation(
    name = "CancelTransaction",
    http_method = "POST",
    http_path = "/CancelTransaction",
    paginator = list()
  )
  input <- .lakeformation$cancel_transaction_input(TransactionId = TransactionId)
  output <- .lakeformation$cancel_transaction_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$cancel_transaction <- lakeformation_cancel_transaction

#' Attempts to commit the specified transaction
#'
#' @description
#' Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted. This API action is idempotent if called multiple times for the same transaction.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_commit_transaction/](https://www.paws-r-sdk.com/docs/lakeformation_commit_transaction/) for full documentation.
#'
#' @param TransactionId &#91;required&#93; The transaction to commit.
#'
#' @keywords internal
#'
#' @rdname lakeformation_commit_transaction
lakeformation_commit_transaction <- function(TransactionId) {
  op <- new_operation(
    name = "CommitTransaction",
    http_method = "POST",
    http_path = "/CommitTransaction",
    paginator = list()
  )
  input <- .lakeformation$commit_transaction_input(TransactionId = TransactionId)
  output <- .lakeformation$commit_transaction_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$commit_transaction <- lakeformation_commit_transaction

#' Creates a data cell filter to allow one to grant access to certain
#' columns on certain rows
#'
#' @description
#' Creates a data cell filter to allow one to grant access to certain columns on certain rows.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_create_data_cells_filter/](https://www.paws-r-sdk.com/docs/lakeformation_create_data_cells_filter/) for full documentation.
#'
#' @param TableData &#91;required&#93; A `DataCellsFilter` structure containing information about the data
#' cells filter.
#'
#' @keywords internal
#'
#' @rdname lakeformation_create_data_cells_filter
lakeformation_create_data_cells_filter <- function(TableData) {
  op <- new_operation(
    name = "CreateDataCellsFilter",
    http_method = "POST",
    http_path = "/CreateDataCellsFilter",
    paginator = list()
  )
  input <- .lakeformation$create_data_cells_filter_input(TableData = TableData)
  output <- .lakeformation$create_data_cells_filter_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$create_data_cells_filter <- lakeformation_create_data_cells_filter

#' Creates an LF-tag with the specified name and values
#'
#' @description
#' Creates an LF-tag with the specified name and values.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_create_lf_tag/](https://www.paws-r-sdk.com/docs/lakeformation_create_lf_tag/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param TagKey &#91;required&#93; The key-name for the LF-tag.
#' @param TagValues &#91;required&#93; A list of possible values an attribute can take.
#'
#' @keywords internal
#'
#' @rdname lakeformation_create_lf_tag
lakeformation_create_lf_tag <- function(CatalogId = NULL, TagKey, TagValues) {
  op <- new_operation(
    name = "CreateLFTag",
    http_method = "POST",
    http_path = "/CreateLFTag",
    paginator = list()
  )
  input <- .lakeformation$create_lf_tag_input(CatalogId = CatalogId, TagKey = TagKey, TagValues = TagValues)
  output <- .lakeformation$create_lf_tag_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$create_lf_tag <- lakeformation_create_lf_tag

#' Creates an IAM Identity Center connection with Lake Formation to allow
#' IAM Identity Center users and groups to access Data Catalog resources
#'
#' @description
#' Creates an IAM Identity Center connection with Lake Formation to allow IAM Identity Center users and groups to access Data Catalog resources.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_create_lake_formation_identity_center_configuration/](https://www.paws-r-sdk.com/docs/lakeformation_create_lake_formation_identity_center_configuration/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, view definitions, and other control
#' information to manage your Lake Formation environment.
#' @param InstanceArn The ARN of the IAM Identity Center instance for which the operation will
#' be executed. For more information about ARNs, see Amazon Resource Names
#' (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web
#' Services General Reference.
#' @param ExternalFiltering A list of the account IDs of Amazon Web Services accounts of third-party
#' applications that are allowed to access data managed by Lake Formation.
#' @param ShareRecipients A list of Amazon Web Services account IDs and/or Amazon Web Services
#' organization/organizational unit ARNs that are allowed to access data
#' managed by Lake Formation.
#' 
#' If the `ShareRecipients` list includes valid values, a resource share is
#' created with the principals you want to have access to the resources.
#' 
#' If the `ShareRecipients` value is null or the list is empty, no resource
#' share is created.
#'
#' @keywords internal
#'
#' @rdname lakeformation_create_lake_format_identi_center_config
lakeformation_create_lake_formation_identity_center_configuration <- function(CatalogId = NULL, InstanceArn = NULL, ExternalFiltering = NULL, ShareRecipients = NULL) {
  op <- new_operation(
    name = "CreateLakeFormationIdentityCenterConfiguration",
    http_method = "POST",
    http_path = "/CreateLakeFormationIdentityCenterConfiguration",
    paginator = list()
  )
  input <- .lakeformation$create_lake_formation_identity_center_configuration_input(CatalogId = CatalogId, InstanceArn = InstanceArn, ExternalFiltering = ExternalFiltering, ShareRecipients = ShareRecipients)
  output <- .lakeformation$create_lake_formation_identity_center_configuration_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$create_lake_formation_identity_center_configuration <- lakeformation_create_lake_formation_identity_center_configuration

#' Enforce Lake Formation permissions for the given databases, tables, and
#' principals
#'
#' @description
#' Enforce Lake Formation permissions for the given databases, tables, and principals.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_create_lake_formation_opt_in/](https://www.paws-r-sdk.com/docs/lakeformation_create_lake_formation_opt_in/) for full documentation.
#'
#' @param Principal &#91;required&#93; 
#' @param Resource &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname lakeformation_create_lake_formation_opt_in
lakeformation_create_lake_formation_opt_in <- function(Principal, Resource) {
  op <- new_operation(
    name = "CreateLakeFormationOptIn",
    http_method = "POST",
    http_path = "/CreateLakeFormationOptIn",
    paginator = list()
  )
  input <- .lakeformation$create_lake_formation_opt_in_input(Principal = Principal, Resource = Resource)
  output <- .lakeformation$create_lake_formation_opt_in_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$create_lake_formation_opt_in <- lakeformation_create_lake_formation_opt_in

#' Deletes a data cell filter
#'
#' @description
#' Deletes a data cell filter.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_delete_data_cells_filter/](https://www.paws-r-sdk.com/docs/lakeformation_delete_data_cells_filter/) for full documentation.
#'
#' @param TableCatalogId The ID of the catalog to which the table belongs.
#' @param DatabaseName A database in the Glue Data Catalog.
#' @param TableName A table in the database.
#' @param Name The name given by the user to the data filter cell.
#'
#' @keywords internal
#'
#' @rdname lakeformation_delete_data_cells_filter
lakeformation_delete_data_cells_filter <- function(TableCatalogId = NULL, DatabaseName = NULL, TableName = NULL, Name = NULL) {
  op <- new_operation(
    name = "DeleteDataCellsFilter",
    http_method = "POST",
    http_path = "/DeleteDataCellsFilter",
    paginator = list()
  )
  input <- .lakeformation$delete_data_cells_filter_input(TableCatalogId = TableCatalogId, DatabaseName = DatabaseName, TableName = TableName, Name = Name)
  output <- .lakeformation$delete_data_cells_filter_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$delete_data_cells_filter <- lakeformation_delete_data_cells_filter

#' Deletes the specified LF-tag given a key name
#'
#' @description
#' Deletes the specified LF-tag given a key name. If the input parameter tag key was not found, then the operation will throw an exception. When you delete an LF-tag, the `LFTagPolicy` attached to the LF-tag becomes invalid. If the deleted LF-tag was still assigned to any resource, the tag policy attach to the deleted LF-tag will no longer be applied to the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_delete_lf_tag/](https://www.paws-r-sdk.com/docs/lakeformation_delete_lf_tag/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param TagKey &#91;required&#93; The key-name for the LF-tag to delete.
#'
#' @keywords internal
#'
#' @rdname lakeformation_delete_lf_tag
lakeformation_delete_lf_tag <- function(CatalogId = NULL, TagKey) {
  op <- new_operation(
    name = "DeleteLFTag",
    http_method = "POST",
    http_path = "/DeleteLFTag",
    paginator = list()
  )
  input <- .lakeformation$delete_lf_tag_input(CatalogId = CatalogId, TagKey = TagKey)
  output <- .lakeformation$delete_lf_tag_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$delete_lf_tag <- lakeformation_delete_lf_tag

#' Deletes an IAM Identity Center connection with Lake Formation
#'
#' @description
#' Deletes an IAM Identity Center connection with Lake Formation.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_delete_lake_formation_identity_center_configuration/](https://www.paws-r-sdk.com/docs/lakeformation_delete_lake_formation_identity_center_configuration/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, view definition, and other control
#' information to manage your Lake Formation environment.
#'
#' @keywords internal
#'
#' @rdname lakeformation_delete_lake_format_identi_center_config
lakeformation_delete_lake_formation_identity_center_configuration <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "DeleteLakeFormationIdentityCenterConfiguration",
    http_method = "POST",
    http_path = "/DeleteLakeFormationIdentityCenterConfiguration",
    paginator = list()
  )
  input <- .lakeformation$delete_lake_formation_identity_center_configuration_input(CatalogId = CatalogId)
  output <- .lakeformation$delete_lake_formation_identity_center_configuration_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$delete_lake_formation_identity_center_configuration <- lakeformation_delete_lake_formation_identity_center_configuration

#' Remove the Lake Formation permissions enforcement of the given
#' databases, tables, and principals
#'
#' @description
#' Remove the Lake Formation permissions enforcement of the given databases, tables, and principals.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_delete_lake_formation_opt_in/](https://www.paws-r-sdk.com/docs/lakeformation_delete_lake_formation_opt_in/) for full documentation.
#'
#' @param Principal &#91;required&#93; 
#' @param Resource &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname lakeformation_delete_lake_formation_opt_in
lakeformation_delete_lake_formation_opt_in <- function(Principal, Resource) {
  op <- new_operation(
    name = "DeleteLakeFormationOptIn",
    http_method = "POST",
    http_path = "/DeleteLakeFormationOptIn",
    paginator = list()
  )
  input <- .lakeformation$delete_lake_formation_opt_in_input(Principal = Principal, Resource = Resource)
  output <- .lakeformation$delete_lake_formation_opt_in_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$delete_lake_formation_opt_in <- lakeformation_delete_lake_formation_opt_in

#' For a specific governed table, provides a list of Amazon S3 objects that
#' will be written during the current transaction and that can be
#' automatically deleted if the transaction is canceled
#'
#' @description
#' For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3 objects are automatically deleted when a transaction cancels.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_delete_objects_on_cancel/](https://www.paws-r-sdk.com/docs/lakeformation_delete_objects_on_cancel/) for full documentation.
#'
#' @param CatalogId The Glue data catalog that contains the governed table. Defaults to the
#' current account ID.
#' @param DatabaseName &#91;required&#93; The database that contains the governed table.
#' @param TableName &#91;required&#93; The name of the governed table.
#' @param TransactionId &#91;required&#93; ID of the transaction that the writes occur in.
#' @param Objects &#91;required&#93; A list of VirtualObject structures, which indicates the Amazon S3
#' objects to be deleted if the transaction cancels.
#'
#' @keywords internal
#'
#' @rdname lakeformation_delete_objects_on_cancel
lakeformation_delete_objects_on_cancel <- function(CatalogId = NULL, DatabaseName, TableName, TransactionId, Objects) {
  op <- new_operation(
    name = "DeleteObjectsOnCancel",
    http_method = "POST",
    http_path = "/DeleteObjectsOnCancel",
    paginator = list()
  )
  input <- .lakeformation$delete_objects_on_cancel_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, TransactionId = TransactionId, Objects = Objects)
  output <- .lakeformation$delete_objects_on_cancel_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$delete_objects_on_cancel <- lakeformation_delete_objects_on_cancel

#' Deregisters the resource as managed by the Data Catalog
#'
#' @description
#' Deregisters the resource as managed by the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_deregister_resource/](https://www.paws-r-sdk.com/docs/lakeformation_deregister_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to
#' deregister.
#'
#' @keywords internal
#'
#' @rdname lakeformation_deregister_resource
lakeformation_deregister_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "DeregisterResource",
    http_method = "POST",
    http_path = "/DeregisterResource",
    paginator = list()
  )
  input <- .lakeformation$deregister_resource_input(ResourceArn = ResourceArn)
  output <- .lakeformation$deregister_resource_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$deregister_resource <- lakeformation_deregister_resource

#' Retrieves the instance ARN and application ARN for the connection
#'
#' @description
#' Retrieves the instance ARN and application ARN for the connection.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_describe_lake_formation_identity_center_configuration/](https://www.paws-r-sdk.com/docs/lakeformation_describe_lake_formation_identity_center_configuration/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#'
#' @keywords internal
#'
#' @rdname lakeformation_descri_lake_format_identi_center_config
lakeformation_describe_lake_formation_identity_center_configuration <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "DescribeLakeFormationIdentityCenterConfiguration",
    http_method = "POST",
    http_path = "/DescribeLakeFormationIdentityCenterConfiguration",
    paginator = list()
  )
  input <- .lakeformation$describe_lake_formation_identity_center_configuration_input(CatalogId = CatalogId)
  output <- .lakeformation$describe_lake_formation_identity_center_configuration_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$describe_lake_formation_identity_center_configuration <- lakeformation_describe_lake_formation_identity_center_configuration

#' Retrieves the current data access role for the given resource registered
#' in Lake Formation
#'
#' @description
#' Retrieves the current data access role for the given resource registered in Lake Formation.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_describe_resource/](https://www.paws-r-sdk.com/docs/lakeformation_describe_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource ARN.
#'
#' @keywords internal
#'
#' @rdname lakeformation_describe_resource
lakeformation_describe_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "DescribeResource",
    http_method = "POST",
    http_path = "/DescribeResource",
    paginator = list()
  )
  input <- .lakeformation$describe_resource_input(ResourceArn = ResourceArn)
  output <- .lakeformation$describe_resource_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$describe_resource <- lakeformation_describe_resource

#' Returns the details of a single transaction
#'
#' @description
#' Returns the details of a single transaction.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_describe_transaction/](https://www.paws-r-sdk.com/docs/lakeformation_describe_transaction/) for full documentation.
#'
#' @param TransactionId &#91;required&#93; The transaction for which to return status.
#'
#' @keywords internal
#'
#' @rdname lakeformation_describe_transaction
lakeformation_describe_transaction <- function(TransactionId) {
  op <- new_operation(
    name = "DescribeTransaction",
    http_method = "POST",
    http_path = "/DescribeTransaction",
    paginator = list()
  )
  input <- .lakeformation$describe_transaction_input(TransactionId = TransactionId)
  output <- .lakeformation$describe_transaction_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$describe_transaction <- lakeformation_describe_transaction

#' Indicates to the service that the specified transaction is still active
#' and should not be treated as idle and aborted
#'
#' @description
#' Indicates to the service that the specified transaction is still active and should not be treated as idle and aborted.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_extend_transaction/](https://www.paws-r-sdk.com/docs/lakeformation_extend_transaction/) for full documentation.
#'
#' @param TransactionId The transaction to extend.
#'
#' @keywords internal
#'
#' @rdname lakeformation_extend_transaction
lakeformation_extend_transaction <- function(TransactionId = NULL) {
  op <- new_operation(
    name = "ExtendTransaction",
    http_method = "POST",
    http_path = "/ExtendTransaction",
    paginator = list()
  )
  input <- .lakeformation$extend_transaction_input(TransactionId = TransactionId)
  output <- .lakeformation$extend_transaction_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$extend_transaction <- lakeformation_extend_transaction

#' Returns a data cells filter
#'
#' @description
#' Returns a data cells filter.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_data_cells_filter/](https://www.paws-r-sdk.com/docs/lakeformation_get_data_cells_filter/) for full documentation.
#'
#' @param TableCatalogId &#91;required&#93; The ID of the catalog to which the table belongs.
#' @param DatabaseName &#91;required&#93; A database in the Glue Data Catalog.
#' @param TableName &#91;required&#93; A table in the database.
#' @param Name &#91;required&#93; The name given by the user to the data filter cell.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_data_cells_filter
lakeformation_get_data_cells_filter <- function(TableCatalogId, DatabaseName, TableName, Name) {
  op <- new_operation(
    name = "GetDataCellsFilter",
    http_method = "POST",
    http_path = "/GetDataCellsFilter",
    paginator = list()
  )
  input <- .lakeformation$get_data_cells_filter_input(TableCatalogId = TableCatalogId, DatabaseName = DatabaseName, TableName = TableName, Name = Name)
  output <- .lakeformation$get_data_cells_filter_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_data_cells_filter <- lakeformation_get_data_cells_filter

#' Retrieves the list of the data lake administrators of a Lake
#' Formation-managed data lake
#'
#' @description
#' Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_data_lake_settings/](https://www.paws-r-sdk.com/docs/lakeformation_get_data_lake_settings/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_data_lake_settings
lakeformation_get_data_lake_settings <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetDataLakeSettings",
    http_method = "POST",
    http_path = "/GetDataLakeSettings",
    paginator = list()
  )
  input <- .lakeformation$get_data_lake_settings_input(CatalogId = CatalogId)
  output <- .lakeformation$get_data_lake_settings_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_data_lake_settings <- lakeformation_get_data_lake_settings

#' Returns the Lake Formation permissions for a specified table or database
#' resource located at a path in Amazon S3
#'
#' @description
#' Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. [`get_effective_permissions_for_path`][lakeformation_get_effective_permissions_for_path] will not return databases and tables if the catalog is encrypted.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_effective_permissions_for_path/](https://www.paws-r-sdk.com/docs/lakeformation_get_effective_permissions_for_path/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to get
#' permissions.
#' @param NextToken A continuation token, if this is not the first call to retrieve this
#' list.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_effective_permissions_for_path
lakeformation_get_effective_permissions_for_path <- function(CatalogId = NULL, ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetEffectivePermissionsForPath",
    http_method = "POST",
    http_path = "/GetEffectivePermissionsForPath",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$get_effective_permissions_for_path_input(CatalogId = CatalogId, ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .lakeformation$get_effective_permissions_for_path_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_effective_permissions_for_path <- lakeformation_get_effective_permissions_for_path

#' Returns an LF-tag definition
#'
#' @description
#' Returns an LF-tag definition.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_lf_tag/](https://www.paws-r-sdk.com/docs/lakeformation_get_lf_tag/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param TagKey &#91;required&#93; The key-name for the LF-tag.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_lf_tag
lakeformation_get_lf_tag <- function(CatalogId = NULL, TagKey) {
  op <- new_operation(
    name = "GetLFTag",
    http_method = "POST",
    http_path = "/GetLFTag",
    paginator = list()
  )
  input <- .lakeformation$get_lf_tag_input(CatalogId = CatalogId, TagKey = TagKey)
  output <- .lakeformation$get_lf_tag_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_lf_tag <- lakeformation_get_lf_tag

#' Returns the state of a query previously submitted
#'
#' @description
#' Returns the state of a query previously submitted. Clients are expected to poll [`get_query_state`][lakeformation_get_query_state] to monitor the current state of the planning before retrieving the work units. A query state is only visible to the principal that made the initial call to [`start_query_planning`][lakeformation_start_query_planning].
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_query_state/](https://www.paws-r-sdk.com/docs/lakeformation_get_query_state/) for full documentation.
#'
#' @param QueryId &#91;required&#93; The ID of the plan query operation.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_query_state
lakeformation_get_query_state <- function(QueryId) {
  op <- new_operation(
    name = "GetQueryState",
    http_method = "POST",
    http_path = "/GetQueryState",
    paginator = list()
  )
  input <- .lakeformation$get_query_state_input(QueryId = QueryId)
  output <- .lakeformation$get_query_state_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_query_state <- lakeformation_get_query_state

#' Retrieves statistics on the planning and execution of a query
#'
#' @description
#' Retrieves statistics on the planning and execution of a query.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_query_statistics/](https://www.paws-r-sdk.com/docs/lakeformation_get_query_statistics/) for full documentation.
#'
#' @param QueryId &#91;required&#93; The ID of the plan query operation.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_query_statistics
lakeformation_get_query_statistics <- function(QueryId) {
  op <- new_operation(
    name = "GetQueryStatistics",
    http_method = "POST",
    http_path = "/GetQueryStatistics",
    paginator = list()
  )
  input <- .lakeformation$get_query_statistics_input(QueryId = QueryId)
  output <- .lakeformation$get_query_statistics_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_query_statistics <- lakeformation_get_query_statistics

#' Returns the LF-tags applied to a resource
#'
#' @description
#' Returns the LF-tags applied to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_resource_lf_tags/](https://www.paws-r-sdk.com/docs/lakeformation_get_resource_lf_tags/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Resource &#91;required&#93; The database, table, or column resource for which you want to return
#' LF-tags.
#' @param ShowAssignedLFTags Indicates whether to show the assigned LF-tags.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_resource_lf_tags
lakeformation_get_resource_lf_tags <- function(CatalogId = NULL, Resource, ShowAssignedLFTags = NULL) {
  op <- new_operation(
    name = "GetResourceLFTags",
    http_method = "POST",
    http_path = "/GetResourceLFTags",
    paginator = list()
  )
  input <- .lakeformation$get_resource_lf_tags_input(CatalogId = CatalogId, Resource = Resource, ShowAssignedLFTags = ShowAssignedLFTags)
  output <- .lakeformation$get_resource_lf_tags_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_resource_lf_tags <- lakeformation_get_resource_lf_tags

#' Returns the set of Amazon S3 objects that make up the specified governed
#' table
#'
#' @description
#' Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can be specified for time-travel queries.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_table_objects/](https://www.paws-r-sdk.com/docs/lakeformation_get_table_objects/) for full documentation.
#'
#' @param CatalogId The catalog containing the governed table. Defaults to the caller’s
#' account.
#' @param DatabaseName &#91;required&#93; The database containing the governed table.
#' @param TableName &#91;required&#93; The governed table for which to retrieve objects.
#' @param TransactionId The transaction ID at which to read the governed table contents. If this
#' transaction has aborted, an error is returned. If not set, defaults to
#' the most recent committed transaction. Cannot be specified along with
#' `QueryAsOfTime`.
#' @param QueryAsOfTime The time as of when to read the governed table contents. If not set, the
#' most recent transaction commit time is used. Cannot be specified along
#' with `TransactionId`.
#' @param PartitionPredicate A predicate to filter the objects returned based on the partition keys
#' defined in the governed table.
#' 
#' -   The comparison operators supported are: =, \>, \<, \>=, \<=
#' 
#' -   The logical operators supported are: AND
#' 
#' -   The data types supported are integer, long, date(yyyy-MM-dd),
#'     timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string
#'     and decimal.
#' @param MaxResults Specifies how many values to return in a page.
#' @param NextToken A continuation token if this is not the first call to retrieve these
#' objects.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_table_objects
lakeformation_get_table_objects <- function(CatalogId = NULL, DatabaseName, TableName, TransactionId = NULL, QueryAsOfTime = NULL, PartitionPredicate = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTableObjects",
    http_method = "POST",
    http_path = "/GetTableObjects",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$get_table_objects_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, TransactionId = TransactionId, QueryAsOfTime = QueryAsOfTime, PartitionPredicate = PartitionPredicate, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lakeformation$get_table_objects_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_table_objects <- lakeformation_get_table_objects

#' This API is identical to GetTemporaryTableCredentials except that this
#' is used when the target Data Catalog resource is of type Partition
#'
#' @description
#' This API is identical to `GetTemporaryTableCredentials` except that this is used when the target Data Catalog resource is of type Partition. Lake Formation restricts the permission of the vended credentials with the same scope down policy which restricts access to a single Amazon S3 prefix.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_temporary_glue_partition_credentials/](https://www.paws-r-sdk.com/docs/lakeformation_get_temporary_glue_partition_credentials/) for full documentation.
#'
#' @param TableArn &#91;required&#93; The ARN of the partitions' table.
#' @param Partition &#91;required&#93; A list of partition values identifying a single partition.
#' @param Permissions Filters the request based on the user having been granted a list of
#' specified permissions on the requested resource(s).
#' @param DurationSeconds The time period, between 900 and 21,600 seconds, for the timeout of the
#' temporary credentials.
#' @param AuditContext A structure representing context to access a resource (column names,
#' query ID, etc).
#' @param SupportedPermissionTypes A list of supported permission types for the partition. Valid values are
#' `COLUMN_PERMISSION` and `CELL_FILTER_PERMISSION`.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_temporary_glue_partition_credentials
lakeformation_get_temporary_glue_partition_credentials <- function(TableArn, Partition, Permissions = NULL, DurationSeconds = NULL, AuditContext = NULL, SupportedPermissionTypes = NULL) {
  op <- new_operation(
    name = "GetTemporaryGluePartitionCredentials",
    http_method = "POST",
    http_path = "/GetTemporaryGluePartitionCredentials",
    paginator = list()
  )
  input <- .lakeformation$get_temporary_glue_partition_credentials_input(TableArn = TableArn, Partition = Partition, Permissions = Permissions, DurationSeconds = DurationSeconds, AuditContext = AuditContext, SupportedPermissionTypes = SupportedPermissionTypes)
  output <- .lakeformation$get_temporary_glue_partition_credentials_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_temporary_glue_partition_credentials <- lakeformation_get_temporary_glue_partition_credentials

#' Allows a caller in a secure environment to assume a role with permission
#' to access Amazon S3
#'
#' @description
#' Allows a caller in a secure environment to assume a role with permission to access Amazon S3. In order to vend such credentials, Lake Formation assumes the role associated with a registered location, for example an Amazon S3 bucket, with a scope down policy which restricts the access to a single prefix.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_temporary_glue_table_credentials/](https://www.paws-r-sdk.com/docs/lakeformation_get_temporary_glue_table_credentials/) for full documentation.
#'
#' @param TableArn &#91;required&#93; The ARN identifying a table in the Data Catalog for the temporary
#' credentials request.
#' @param Permissions Filters the request based on the user having been granted a list of
#' specified permissions on the requested resource(s).
#' @param DurationSeconds The time period, between 900 and 21,600 seconds, for the timeout of the
#' temporary credentials.
#' @param AuditContext A structure representing context to access a resource (column names,
#' query ID, etc).
#' @param SupportedPermissionTypes A list of supported permission types for the table. Valid values are
#' `COLUMN_PERMISSION` and `CELL_FILTER_PERMISSION`.
#' @param S3Path The Amazon S3 path for the table.
#' @param QuerySessionContext A structure used as a protocol between query engines and Lake Formation
#' or Glue. Contains both a Lake Formation generated authorization
#' identifier and information from the request's authorization context.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_temporary_glue_table_credentials
lakeformation_get_temporary_glue_table_credentials <- function(TableArn, Permissions = NULL, DurationSeconds = NULL, AuditContext = NULL, SupportedPermissionTypes = NULL, S3Path = NULL, QuerySessionContext = NULL) {
  op <- new_operation(
    name = "GetTemporaryGlueTableCredentials",
    http_method = "POST",
    http_path = "/GetTemporaryGlueTableCredentials",
    paginator = list()
  )
  input <- .lakeformation$get_temporary_glue_table_credentials_input(TableArn = TableArn, Permissions = Permissions, DurationSeconds = DurationSeconds, AuditContext = AuditContext, SupportedPermissionTypes = SupportedPermissionTypes, S3Path = S3Path, QuerySessionContext = QuerySessionContext)
  output <- .lakeformation$get_temporary_glue_table_credentials_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_temporary_glue_table_credentials <- lakeformation_get_temporary_glue_table_credentials

#' Returns the work units resulting from the query
#'
#' @description
#' Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_work_unit_results/](https://www.paws-r-sdk.com/docs/lakeformation_get_work_unit_results/) for full documentation.
#'
#' @param QueryId &#91;required&#93; The ID of the plan query operation for which to get results.
#' @param WorkUnitId &#91;required&#93; The work unit ID for which to get results. Value generated by
#' enumerating `WorkUnitIdMin` to `WorkUnitIdMax` (inclusive) from the
#' `WorkUnitRange` in the output of
#' [`get_work_units`][lakeformation_get_work_units].
#' @param WorkUnitToken &#91;required&#93; A work token used to query the execution service. Token output from
#' [`get_work_units`][lakeformation_get_work_units].
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_work_unit_results
lakeformation_get_work_unit_results <- function(QueryId, WorkUnitId, WorkUnitToken) {
  op <- new_operation(
    name = "GetWorkUnitResults",
    http_method = "POST",
    http_path = "/GetWorkUnitResults",
    paginator = list()
  )
  input <- .lakeformation$get_work_unit_results_input(QueryId = QueryId, WorkUnitId = WorkUnitId, WorkUnitToken = WorkUnitToken)
  output <- .lakeformation$get_work_unit_results_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_work_unit_results <- lakeformation_get_work_unit_results

#' Retrieves the work units generated by the StartQueryPlanning operation
#'
#' @description
#' Retrieves the work units generated by the [`start_query_planning`][lakeformation_start_query_planning] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_get_work_units/](https://www.paws-r-sdk.com/docs/lakeformation_get_work_units/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param PageSize The size of each page to get in the Amazon Web Services service call.
#' This does not affect the number of items returned in the command's
#' output. Setting a smaller page size results in more calls to the Amazon
#' Web Services service, retrieving fewer items in each call. This can help
#' prevent the Amazon Web Services service calls from timing out.
#' @param QueryId &#91;required&#93; The ID of the plan query operation.
#'
#' @keywords internal
#'
#' @rdname lakeformation_get_work_units
lakeformation_get_work_units <- function(NextToken = NULL, PageSize = NULL, QueryId) {
  op <- new_operation(
    name = "GetWorkUnits",
    http_method = "POST",
    http_path = "/GetWorkUnits",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken", result_key = "WorkUnitRanges")
  )
  input <- .lakeformation$get_work_units_input(NextToken = NextToken, PageSize = PageSize, QueryId = QueryId)
  output <- .lakeformation$get_work_units_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$get_work_units <- lakeformation_get_work_units

#' Grants permissions to the principal to access metadata in the Data
#' Catalog and data organized in underlying data storage such as Amazon S3
#'
#' @description
#' Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_grant_permissions/](https://www.paws-r-sdk.com/docs/lakeformation_grant_permissions/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Principal &#91;required&#93; The principal to be granted the permissions on the resource. Supported
#' principals are IAM users or IAM roles, and they are defined by their
#' principal type and their ARN.
#' 
#' Note that if you define a resource with a particular ARN, then later
#' delete, and recreate a resource with that same ARN, the resource
#' maintains the permissions already granted.
#' @param Resource &#91;required&#93; The resource to which permissions are to be granted. Resources in Lake
#' Formation are the Data Catalog, databases, and tables.
#' @param Permissions &#91;required&#93; The permissions granted to the principal on the resource. Lake Formation
#' defines privileges to grant and revoke access to metadata in the Data
#' Catalog and data organized in underlying data storage such as Amazon S3.
#' Lake Formation requires that each principal be authorized to perform a
#' specific task on Lake Formation resources.
#' @param PermissionsWithGrantOption Indicates a list of the granted permissions that the principal may pass
#' to other users. These permissions may only be a subset of the
#' permissions granted in the `Privileges`.
#'
#' @keywords internal
#'
#' @rdname lakeformation_grant_permissions
lakeformation_grant_permissions <- function(CatalogId = NULL, Principal, Resource, Permissions, PermissionsWithGrantOption = NULL) {
  op <- new_operation(
    name = "GrantPermissions",
    http_method = "POST",
    http_path = "/GrantPermissions",
    paginator = list()
  )
  input <- .lakeformation$grant_permissions_input(CatalogId = CatalogId, Principal = Principal, Resource = Resource, Permissions = Permissions, PermissionsWithGrantOption = PermissionsWithGrantOption)
  output <- .lakeformation$grant_permissions_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$grant_permissions <- lakeformation_grant_permissions

#' Lists all the data cell filters on a table
#'
#' @description
#' Lists all the data cell filters on a table.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_data_cells_filter/](https://www.paws-r-sdk.com/docs/lakeformation_list_data_cells_filter/) for full documentation.
#'
#' @param Table A table in the Glue Data Catalog.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_data_cells_filter
lakeformation_list_data_cells_filter <- function(Table = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataCellsFilter",
    http_method = "POST",
    http_path = "/ListDataCellsFilter",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DataCellsFilters")
  )
  input <- .lakeformation$list_data_cells_filter_input(Table = Table, NextToken = NextToken, MaxResults = MaxResults)
  output <- .lakeformation$list_data_cells_filter_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_data_cells_filter <- lakeformation_list_data_cells_filter

#' Lists LF-tags that the requester has permission to view
#'
#' @description
#' Lists LF-tags that the requester has permission to view.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_lf_tags/](https://www.paws-r-sdk.com/docs/lakeformation_list_lf_tags/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param ResourceShareType If resource share type is `ALL`, returns both in-account LF-tags and
#' shared LF-tags that the requester has permission to view. If resource
#' share type is `FOREIGN`, returns all share LF-tags that the requester
#' can view. If no resource share type is passed, lists LF-tags in the
#' given catalog ID that the requester has permission to view.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken A continuation token, if this is not the first call to retrieve this
#' list.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_lf_tags
lakeformation_list_lf_tags <- function(CatalogId = NULL, ResourceShareType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLFTags",
    http_method = "POST",
    http_path = "/ListLFTags",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LFTags")
  )
  input <- .lakeformation$list_lf_tags_input(CatalogId = CatalogId, ResourceShareType = ResourceShareType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lakeformation$list_lf_tags_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_lf_tags <- lakeformation_list_lf_tags

#' Retrieve the current list of resources and principals that are opt in to
#' enforce Lake Formation permissions
#'
#' @description
#' Retrieve the current list of resources and principals that are opt in to enforce Lake Formation permissions.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_lake_formation_opt_ins/](https://www.paws-r-sdk.com/docs/lakeformation_list_lake_formation_opt_ins/) for full documentation.
#'
#' @param Principal 
#' @param Resource A structure for the resource.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken A continuation token, if this is not the first call to retrieve this
#' list.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_lake_formation_opt_ins
lakeformation_list_lake_formation_opt_ins <- function(Principal = NULL, Resource = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLakeFormationOptIns",
    http_method = "POST",
    http_path = "/ListLakeFormationOptIns",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$list_lake_formation_opt_ins_input(Principal = Principal, Resource = Resource, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lakeformation$list_lake_formation_opt_ins_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_lake_formation_opt_ins <- lakeformation_list_lake_formation_opt_ins

#' Returns a list of the principal permissions on the resource, filtered by
#' the permissions of the caller
#'
#' @description
#' Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_permissions/](https://www.paws-r-sdk.com/docs/lakeformation_list_permissions/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Principal Specifies a principal to filter the permissions returned.
#' @param ResourceType Specifies a resource type to filter the permissions returned.
#' @param Resource A resource where you will get a list of the principal permissions.
#' 
#' This operation does not support getting privileges on a table with
#' columns. Instead, call this operation on the table, and the operation
#' returns the table and the table w columns.
#' @param NextToken A continuation token, if this is not the first call to retrieve this
#' list.
#' @param MaxResults The maximum number of results to return.
#' @param IncludeRelated Indicates that related permissions should be included in the results.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_permissions
lakeformation_list_permissions <- function(CatalogId = NULL, Principal = NULL, ResourceType = NULL, Resource = NULL, NextToken = NULL, MaxResults = NULL, IncludeRelated = NULL) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "POST",
    http_path = "/ListPermissions",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$list_permissions_input(CatalogId = CatalogId, Principal = Principal, ResourceType = ResourceType, Resource = Resource, NextToken = NextToken, MaxResults = MaxResults, IncludeRelated = IncludeRelated)
  output <- .lakeformation$list_permissions_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_permissions <- lakeformation_list_permissions

#' Lists the resources registered to be managed by the Data Catalog
#'
#' @description
#' Lists the resources registered to be managed by the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_resources/](https://www.paws-r-sdk.com/docs/lakeformation_list_resources/) for full documentation.
#'
#' @param FilterConditionList Any applicable row-level and/or column-level filtering conditions for
#' the resources.
#' @param MaxResults The maximum number of resource results.
#' @param NextToken A continuation token, if this is not the first call to retrieve these
#' resources.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_resources
lakeformation_list_resources <- function(FilterConditionList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/ListResources",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$list_resources_input(FilterConditionList = FilterConditionList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lakeformation$list_resources_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_resources <- lakeformation_list_resources

#' Returns the configuration of all storage optimizers associated with a
#' specified table
#'
#' @description
#' Returns the configuration of all storage optimizers associated with a specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_table_storage_optimizers/](https://www.paws-r-sdk.com/docs/lakeformation_list_table_storage_optimizers/) for full documentation.
#'
#' @param CatalogId The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; Name of the database where the table is present.
#' @param TableName &#91;required&#93; Name of the table.
#' @param StorageOptimizerType The specific type of storage optimizers to list. The supported value is
#' `compaction`.
#' @param MaxResults The number of storage optimizers to return on each call.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_table_storage_optimizers
lakeformation_list_table_storage_optimizers <- function(CatalogId = NULL, DatabaseName, TableName, StorageOptimizerType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTableStorageOptimizers",
    http_method = "POST",
    http_path = "/ListTableStorageOptimizers",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$list_table_storage_optimizers_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, StorageOptimizerType = StorageOptimizerType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lakeformation$list_table_storage_optimizers_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_table_storage_optimizers <- lakeformation_list_table_storage_optimizers

#' Returns metadata about transactions and their status
#'
#' @description
#' Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only uncommitted transactions and those available for time-travel queries are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_list_transactions/](https://www.paws-r-sdk.com/docs/lakeformation_list_transactions/) for full documentation.
#'
#' @param CatalogId The catalog for which to list transactions. Defaults to the account ID
#' of the caller.
#' @param StatusFilter A filter indicating the status of transactions to return. Options are
#' ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is `ALL`.
#' @param MaxResults The maximum number of transactions to return in a single call.
#' @param NextToken A continuation token if this is not the first call to retrieve
#' transactions.
#'
#' @keywords internal
#'
#' @rdname lakeformation_list_transactions
lakeformation_list_transactions <- function(CatalogId = NULL, StatusFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTransactions",
    http_method = "POST",
    http_path = "/ListTransactions",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .lakeformation$list_transactions_input(CatalogId = CatalogId, StatusFilter = StatusFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lakeformation$list_transactions_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$list_transactions <- lakeformation_list_transactions

#' Sets the list of data lake administrators who have admin privileges on
#' all resources managed by Lake Formation
#'
#' @description
#' Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see [Granting Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/).
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_put_data_lake_settings/](https://www.paws-r-sdk.com/docs/lakeformation_put_data_lake_settings/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param DataLakeSettings &#91;required&#93; A structure representing a list of Lake Formation principals designated
#' as data lake administrators.
#'
#' @keywords internal
#'
#' @rdname lakeformation_put_data_lake_settings
lakeformation_put_data_lake_settings <- function(CatalogId = NULL, DataLakeSettings) {
  op <- new_operation(
    name = "PutDataLakeSettings",
    http_method = "POST",
    http_path = "/PutDataLakeSettings",
    paginator = list()
  )
  input <- .lakeformation$put_data_lake_settings_input(CatalogId = CatalogId, DataLakeSettings = DataLakeSettings)
  output <- .lakeformation$put_data_lake_settings_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$put_data_lake_settings <- lakeformation_put_data_lake_settings

#' Registers the resource as managed by the Data Catalog
#'
#' @description
#' Registers the resource as managed by the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_register_resource/](https://www.paws-r-sdk.com/docs/lakeformation_register_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to
#' register.
#' @param UseServiceLinkedRole Designates an Identity and Access Management (IAM) service-linked role
#' by registering this role with the Data Catalog. A service-linked role is
#' a unique type of IAM role that is linked directly to Lake Formation.
#' 
#' For more information, see [Using Service-Linked Roles for Lake
#' Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html).
#' @param RoleArn The identifier for the role that registers the resource.
#' @param WithFederation Whether or not the resource is a federated resource.
#' @param HybridAccessEnabled Specifies whether the data access of tables pointing to the location can
#' be managed by both Lake Formation permissions as well as Amazon S3
#' bucket policies.
#'
#' @keywords internal
#'
#' @rdname lakeformation_register_resource
lakeformation_register_resource <- function(ResourceArn, UseServiceLinkedRole = NULL, RoleArn = NULL, WithFederation = NULL, HybridAccessEnabled = NULL) {
  op <- new_operation(
    name = "RegisterResource",
    http_method = "POST",
    http_path = "/RegisterResource",
    paginator = list()
  )
  input <- .lakeformation$register_resource_input(ResourceArn = ResourceArn, UseServiceLinkedRole = UseServiceLinkedRole, RoleArn = RoleArn, WithFederation = WithFederation, HybridAccessEnabled = HybridAccessEnabled)
  output <- .lakeformation$register_resource_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$register_resource <- lakeformation_register_resource

#' Removes an LF-tag from the resource
#'
#' @description
#' Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in `tableWithColumns` to specify column input.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_remove_lf_tags_from_resource/](https://www.paws-r-sdk.com/docs/lakeformation_remove_lf_tags_from_resource/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Resource &#91;required&#93; The database, table, or column resource where you want to remove an
#' LF-tag.
#' @param LFTags &#91;required&#93; The LF-tags to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname lakeformation_remove_lf_tags_from_resource
lakeformation_remove_lf_tags_from_resource <- function(CatalogId = NULL, Resource, LFTags) {
  op <- new_operation(
    name = "RemoveLFTagsFromResource",
    http_method = "POST",
    http_path = "/RemoveLFTagsFromResource",
    paginator = list()
  )
  input <- .lakeformation$remove_lf_tags_from_resource_input(CatalogId = CatalogId, Resource = Resource, LFTags = LFTags)
  output <- .lakeformation$remove_lf_tags_from_resource_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$remove_lf_tags_from_resource <- lakeformation_remove_lf_tags_from_resource

#' Revokes permissions to the principal to access metadata in the Data
#' Catalog and data organized in underlying data storage such as Amazon S3
#'
#' @description
#' Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_revoke_permissions/](https://www.paws-r-sdk.com/docs/lakeformation_revoke_permissions/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Principal &#91;required&#93; The principal to be revoked permissions on the resource.
#' @param Resource &#91;required&#93; The resource to which permissions are to be revoked.
#' @param Permissions &#91;required&#93; The permissions revoked to the principal on the resource. For
#' information about permissions, see [Security and Access Control to
#' Metadata and
#' Data](https://docs.aws.amazon.com/lake-formation/latest/dg/).
#' @param PermissionsWithGrantOption Indicates a list of permissions for which to revoke the grant option
#' allowing the principal to pass permissions to other principals.
#'
#' @keywords internal
#'
#' @rdname lakeformation_revoke_permissions
lakeformation_revoke_permissions <- function(CatalogId = NULL, Principal, Resource, Permissions, PermissionsWithGrantOption = NULL) {
  op <- new_operation(
    name = "RevokePermissions",
    http_method = "POST",
    http_path = "/RevokePermissions",
    paginator = list()
  )
  input <- .lakeformation$revoke_permissions_input(CatalogId = CatalogId, Principal = Principal, Resource = Resource, Permissions = Permissions, PermissionsWithGrantOption = PermissionsWithGrantOption)
  output <- .lakeformation$revoke_permissions_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$revoke_permissions <- lakeformation_revoke_permissions

#' This operation allows a search on DATABASE resources by TagCondition
#'
#' @description
#' This operation allows a search on `DATABASE` resources by `TagCondition`. This operation is used by admins who want to grant user permissions on certain `TagConditions`. Before making a grant, the admin can use `SearchDatabasesByTags` to find all resources where the given `TagConditions` are valid to verify whether the returned resources can be shared.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_search_databases_by_lf_tags/](https://www.paws-r-sdk.com/docs/lakeformation_search_databases_by_lf_tags/) for full documentation.
#'
#' @param NextToken A continuation token, if this is not the first call to retrieve this
#' list.
#' @param MaxResults The maximum number of results to return.
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Expression &#91;required&#93; A list of conditions (`LFTag` structures) to search for in database
#' resources.
#'
#' @keywords internal
#'
#' @rdname lakeformation_search_databases_by_lf_tags
lakeformation_search_databases_by_lf_tags <- function(NextToken = NULL, MaxResults = NULL, CatalogId = NULL, Expression) {
  op <- new_operation(
    name = "SearchDatabasesByLFTags",
    http_method = "POST",
    http_path = "/SearchDatabasesByLFTags",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DatabaseList")
  )
  input <- .lakeformation$search_databases_by_lf_tags_input(NextToken = NextToken, MaxResults = MaxResults, CatalogId = CatalogId, Expression = Expression)
  output <- .lakeformation$search_databases_by_lf_tags_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$search_databases_by_lf_tags <- lakeformation_search_databases_by_lf_tags

#' This operation allows a search on TABLE resources by LFTags
#'
#' @description
#' This operation allows a search on `TABLE` resources by `LFTag`s. This will be used by admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use [`search_tables_by_lf_tags`][lakeformation_search_tables_by_lf_tags] to find all resources where the given `LFTag`s are valid to verify whether the returned resources can be shared.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_search_tables_by_lf_tags/](https://www.paws-r-sdk.com/docs/lakeformation_search_tables_by_lf_tags/) for full documentation.
#'
#' @param NextToken A continuation token, if this is not the first call to retrieve this
#' list.
#' @param MaxResults The maximum number of results to return.
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param Expression &#91;required&#93; A list of conditions (`LFTag` structures) to search for in table
#' resources.
#'
#' @keywords internal
#'
#' @rdname lakeformation_search_tables_by_lf_tags
lakeformation_search_tables_by_lf_tags <- function(NextToken = NULL, MaxResults = NULL, CatalogId = NULL, Expression) {
  op <- new_operation(
    name = "SearchTablesByLFTags",
    http_method = "POST",
    http_path = "/SearchTablesByLFTags",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TableList")
  )
  input <- .lakeformation$search_tables_by_lf_tags_input(NextToken = NextToken, MaxResults = MaxResults, CatalogId = CatalogId, Expression = Expression)
  output <- .lakeformation$search_tables_by_lf_tags_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$search_tables_by_lf_tags <- lakeformation_search_tables_by_lf_tags

#' Submits a request to process a query statement
#'
#' @description
#' Submits a request to process a query statement.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_start_query_planning/](https://www.paws-r-sdk.com/docs/lakeformation_start_query_planning/) for full documentation.
#'
#' @param QueryPlanningContext &#91;required&#93; A structure containing information about the query plan.
#' @param QueryString &#91;required&#93; A PartiQL query statement used as an input to the planner service.
#'
#' @keywords internal
#'
#' @rdname lakeformation_start_query_planning
lakeformation_start_query_planning <- function(QueryPlanningContext, QueryString) {
  op <- new_operation(
    name = "StartQueryPlanning",
    http_method = "POST",
    http_path = "/StartQueryPlanning",
    paginator = list()
  )
  input <- .lakeformation$start_query_planning_input(QueryPlanningContext = QueryPlanningContext, QueryString = QueryString)
  output <- .lakeformation$start_query_planning_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$start_query_planning <- lakeformation_start_query_planning

#' Starts a new transaction and returns its transaction ID
#'
#' @description
#' Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to identify a transaction.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_start_transaction/](https://www.paws-r-sdk.com/docs/lakeformation_start_transaction/) for full documentation.
#'
#' @param TransactionType Indicates whether this transaction should be read only or read and
#' write. Writes made using a read-only transaction ID will be rejected.
#' Read-only transactions do not need to be committed.
#'
#' @keywords internal
#'
#' @rdname lakeformation_start_transaction
lakeformation_start_transaction <- function(TransactionType = NULL) {
  op <- new_operation(
    name = "StartTransaction",
    http_method = "POST",
    http_path = "/StartTransaction",
    paginator = list()
  )
  input <- .lakeformation$start_transaction_input(TransactionType = TransactionType)
  output <- .lakeformation$start_transaction_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$start_transaction <- lakeformation_start_transaction

#' Updates a data cell filter
#'
#' @description
#' Updates a data cell filter.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_update_data_cells_filter/](https://www.paws-r-sdk.com/docs/lakeformation_update_data_cells_filter/) for full documentation.
#'
#' @param TableData &#91;required&#93; A `DataCellsFilter` structure containing information about the data
#' cells filter.
#'
#' @keywords internal
#'
#' @rdname lakeformation_update_data_cells_filter
lakeformation_update_data_cells_filter <- function(TableData) {
  op <- new_operation(
    name = "UpdateDataCellsFilter",
    http_method = "POST",
    http_path = "/UpdateDataCellsFilter",
    paginator = list()
  )
  input <- .lakeformation$update_data_cells_filter_input(TableData = TableData)
  output <- .lakeformation$update_data_cells_filter_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$update_data_cells_filter <- lakeformation_update_data_cells_filter

#' Updates the list of possible values for the specified LF-tag key
#'
#' @description
#' Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the LF-tag key's value.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_update_lf_tag/](https://www.paws-r-sdk.com/docs/lakeformation_update_lf_tag/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, and other control information to manage
#' your Lake Formation environment.
#' @param TagKey &#91;required&#93; The key-name for the LF-tag for which to add or delete values.
#' @param TagValuesToDelete A list of LF-tag values to delete from the LF-tag.
#' @param TagValuesToAdd A list of LF-tag values to add from the LF-tag.
#'
#' @keywords internal
#'
#' @rdname lakeformation_update_lf_tag
lakeformation_update_lf_tag <- function(CatalogId = NULL, TagKey, TagValuesToDelete = NULL, TagValuesToAdd = NULL) {
  op <- new_operation(
    name = "UpdateLFTag",
    http_method = "POST",
    http_path = "/UpdateLFTag",
    paginator = list()
  )
  input <- .lakeformation$update_lf_tag_input(CatalogId = CatalogId, TagKey = TagKey, TagValuesToDelete = TagValuesToDelete, TagValuesToAdd = TagValuesToAdd)
  output <- .lakeformation$update_lf_tag_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$update_lf_tag <- lakeformation_update_lf_tag

#' Updates the IAM Identity Center connection parameters
#'
#' @description
#' Updates the IAM Identity Center connection parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_update_lake_formation_identity_center_configuration/](https://www.paws-r-sdk.com/docs/lakeformation_update_lake_formation_identity_center_configuration/) for full documentation.
#'
#' @param CatalogId The identifier for the Data Catalog. By default, the account ID. The
#' Data Catalog is the persistent metadata store. It contains database
#' definitions, table definitions, view definitions, and other control
#' information to manage your Lake Formation environment.
#' @param ShareRecipients A list of Amazon Web Services account IDs or Amazon Web Services
#' organization/organizational unit ARNs that are allowed to access to
#' access data managed by Lake Formation.
#' 
#' If the `ShareRecipients` list includes valid values, then the resource
#' share is updated with the principals you want to have access to the
#' resources.
#' 
#' If the `ShareRecipients` value is null, both the list of share
#' recipients and the resource share remain unchanged.
#' 
#' If the `ShareRecipients` value is an empty list, then the existing share
#' recipients list will be cleared, and the resource share will be deleted.
#' @param ApplicationStatus Allows to enable or disable the IAM Identity Center connection.
#' @param ExternalFiltering A list of the account IDs of Amazon Web Services accounts of third-party
#' applications that are allowed to access data managed by Lake Formation.
#'
#' @keywords internal
#'
#' @rdname lakeformation_update_lake_format_identi_center_config
lakeformation_update_lake_formation_identity_center_configuration <- function(CatalogId = NULL, ShareRecipients = NULL, ApplicationStatus = NULL, ExternalFiltering = NULL) {
  op <- new_operation(
    name = "UpdateLakeFormationIdentityCenterConfiguration",
    http_method = "POST",
    http_path = "/UpdateLakeFormationIdentityCenterConfiguration",
    paginator = list()
  )
  input <- .lakeformation$update_lake_formation_identity_center_configuration_input(CatalogId = CatalogId, ShareRecipients = ShareRecipients, ApplicationStatus = ApplicationStatus, ExternalFiltering = ExternalFiltering)
  output <- .lakeformation$update_lake_formation_identity_center_configuration_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$update_lake_formation_identity_center_configuration <- lakeformation_update_lake_formation_identity_center_configuration

#' Updates the data access role used for vending access to the given
#' (registered) resource in Lake Formation
#'
#' @description
#' Updates the data access role used for vending access to the given (registered) resource in Lake Formation.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_update_resource/](https://www.paws-r-sdk.com/docs/lakeformation_update_resource/) for full documentation.
#'
#' @param RoleArn &#91;required&#93; The new role to use for the given resource registered in Lake Formation.
#' @param ResourceArn &#91;required&#93; The resource ARN.
#' @param WithFederation Whether or not the resource is a federated resource.
#' @param HybridAccessEnabled Specifies whether the data access of tables pointing to the location can
#' be managed by both Lake Formation permissions as well as Amazon S3
#' bucket policies.
#'
#' @keywords internal
#'
#' @rdname lakeformation_update_resource
lakeformation_update_resource <- function(RoleArn, ResourceArn, WithFederation = NULL, HybridAccessEnabled = NULL) {
  op <- new_operation(
    name = "UpdateResource",
    http_method = "POST",
    http_path = "/UpdateResource",
    paginator = list()
  )
  input <- .lakeformation$update_resource_input(RoleArn = RoleArn, ResourceArn = ResourceArn, WithFederation = WithFederation, HybridAccessEnabled = HybridAccessEnabled)
  output <- .lakeformation$update_resource_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$update_resource <- lakeformation_update_resource

#' Updates the manifest of Amazon S3 objects that make up the specified
#' governed table
#'
#' @description
#' Updates the manifest of Amazon S3 objects that make up the specified governed table.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_update_table_objects/](https://www.paws-r-sdk.com/docs/lakeformation_update_table_objects/) for full documentation.
#'
#' @param CatalogId The catalog containing the governed table to update. Defaults to the
#' caller’s account ID.
#' @param DatabaseName &#91;required&#93; The database containing the governed table to update.
#' @param TableName &#91;required&#93; The governed table to update.
#' @param TransactionId The transaction at which to do the write.
#' @param WriteOperations &#91;required&#93; A list of `WriteOperation` objects that define an object to add to or
#' delete from the manifest for a governed table.
#'
#' @keywords internal
#'
#' @rdname lakeformation_update_table_objects
lakeformation_update_table_objects <- function(CatalogId = NULL, DatabaseName, TableName, TransactionId = NULL, WriteOperations) {
  op <- new_operation(
    name = "UpdateTableObjects",
    http_method = "POST",
    http_path = "/UpdateTableObjects",
    paginator = list()
  )
  input <- .lakeformation$update_table_objects_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, TransactionId = TransactionId, WriteOperations = WriteOperations)
  output <- .lakeformation$update_table_objects_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$update_table_objects <- lakeformation_update_table_objects

#' Updates the configuration of the storage optimizers for a table
#'
#' @description
#' Updates the configuration of the storage optimizers for a table.
#'
#' See [https://www.paws-r-sdk.com/docs/lakeformation_update_table_storage_optimizer/](https://www.paws-r-sdk.com/docs/lakeformation_update_table_storage_optimizer/) for full documentation.
#'
#' @param CatalogId The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; Name of the database where the table is present.
#' @param TableName &#91;required&#93; Name of the table for which to enable the storage optimizer.
#' @param StorageOptimizerConfig &#91;required&#93; Name of the table for which to enable the storage optimizer.
#'
#' @keywords internal
#'
#' @rdname lakeformation_update_table_storage_optimizer
lakeformation_update_table_storage_optimizer <- function(CatalogId = NULL, DatabaseName, TableName, StorageOptimizerConfig) {
  op <- new_operation(
    name = "UpdateTableStorageOptimizer",
    http_method = "POST",
    http_path = "/UpdateTableStorageOptimizer",
    paginator = list()
  )
  input <- .lakeformation$update_table_storage_optimizer_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, StorageOptimizerConfig = StorageOptimizerConfig)
  output <- .lakeformation$update_table_storage_optimizer_output()
  config <- get_config()
  svc <- .lakeformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lakeformation$operations$update_table_storage_optimizer <- lakeformation_update_table_storage_optimizer
