% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpledb_operations.R
\name{simpledb_put_attributes}
\alias{simpledb_put_attributes}
\title{The PutAttributes operation creates or replaces attributes in an item}
\usage{
simpledb_put_attributes(DomainName, ItemName, Attributes, Expected = NULL)
}
\arguments{
\item{DomainName}{[required] The name of the domain in which to perform the operation.}

\item{ItemName}{[required] The name of the item.}

\item{Attributes}{[required] The list of attributes.}

\item{Expected}{The update condition which, if specified, determines whether the
specified attributes will be updated or not. The update condition must
be satisfied in order for this request to be processed and the
attributes to be updated.}
}
\description{
The PutAttributes operation creates or replaces attributes in an item. The client may specify new attributes using a combination of the \code{Attribute.X.Name} and \code{Attribute.X.Value} parameters. The client specifies the first attribute by the parameters \code{Attribute.0.Name} and \code{Attribute.0.Value}, the second attribute by the parameters \code{Attribute.1.Name} and \code{Attribute.1.Value}, and so on.

See \url{https://paws-r.github.io/docs/simpledb/put_attributes.html} for full documentation.
}
\keyword{internal}
