% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_snapshot_copy_grant}
\alias{redshift_create_snapshot_copy_grant}
\title{Creates a snapshot copy grant that permits Amazon Redshift to use an
encrypted symmetric key from Key Management Service (KMS) to encrypt
copied snapshots in a destination region}
\usage{
redshift_create_snapshot_copy_grant(
  SnapshotCopyGrantName,
  KmsKeyId = NULL,
  Tags = NULL
)
}
\arguments{
\item{SnapshotCopyGrantName}{[required] The name of the snapshot copy grant. This name must be unique in the
region for the Amazon Web Services account.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item Alphabetic characters must be lowercase.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique for all clusters within an Amazon Web Services
account.
}}

\item{KmsKeyId}{The unique identifier of the encrypted symmetric key to which to grant
Amazon Redshift permission. If no key is specified, the default key is
used.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.

See \url{https://paws-r.github.io/docs/redshift/create_snapshot_copy_grant.html} for full documentation.
}
\keyword{internal}
