% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_activity_stream}
\alias{rds_modify_activity_stream}
\title{Changes the audit policy state of a database activity stream to either
locked (default) or unlocked}
\usage{
rds_modify_activity_stream(ResourceArn = NULL, AuditPolicyState = NULL)
}
\arguments{
\item{ResourceArn}{The Amazon Resource Name (ARN) of the RDS for Oracle DB instance, for
example, \code{arn:aws:rds:us-east-1:12345667890:instance:my-orcl-db}.}

\item{AuditPolicyState}{The audit policy state. When a policy is unlocked, it is read/write.
When it is locked, it is read-only. You can edit your audit policy only
when the activity stream is unlocked or stopped.}
}
\description{
Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream isn't required. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html}{Modifying a database activity stream} in the \emph{Amazon RDS User Guide}.

See \url{https://paws-r.github.io/docs/rds/modify_activity_stream.html} for full documentation.
}
\keyword{internal}
