% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodbstreams_operations.R
\name{dynamodbstreams_get_shard_iterator}
\alias{dynamodbstreams_get_shard_iterator}
\title{Returns a shard iterator}
\usage{
dynamodbstreams_get_shard_iterator(
  StreamArn,
  ShardId,
  ShardIteratorType,
  SequenceNumber = NULL
)
}
\arguments{
\item{StreamArn}{[required] The Amazon Resource Name (ARN) for the stream.}

\item{ShardId}{[required] The identifier of the shard. The iterator will be returned for this
shard ID.}

\item{ShardIteratorType}{[required] Determines how the shard iterator is used to start reading stream
records from the shard:
\itemize{
\item \code{AT_SEQUENCE_NUMBER} - Start reading exactly from the position
denoted by a specific sequence number.
\item \code{AFTER_SEQUENCE_NUMBER} - Start reading right after the position
denoted by a specific sequence number.
\item \code{TRIM_HORIZON} - Start reading at the last (untrimmed) stream
record, which is the oldest record in the shard. In DynamoDB
Streams, there is a 24 hour limit on data retention. Stream records
whose age exceeds this limit are subject to removal (trimming) from
the stream.
\item \code{LATEST} - Start reading just after the most recent stream record in
the shard, so that you always read the most recent data in the
shard.
}}

\item{SequenceNumber}{The sequence number of a stream record in the shard from which to start
reading.}
}
\description{
Returns a shard iterator. A shard iterator provides information about how to retrieve the stream records from within a shard. Use the shard iterator in a subsequent \code{\link[=dynamodbstreams_get_records]{get_records}} request to read the stream records from the shard.

See \url{https://paws-r.github.io/docs/dynamodbstreams/get_shard_iterator.html} for full documentation.
}
\keyword{internal}
