% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_option_group_options}
\alias{rds_describe_option_group_options}
\title{Describes all available options}
\usage{
rds_describe_option_group_options(EngineName, MajorEngineVersion,
  Filters, MaxRecords, Marker)
}
\arguments{
\item{EngineName}{[required] A required parameter. Options available for the given engine name are
described.}

\item{MajorEngineVersion}{If specified, filters the results to include only options for the
specified major engine version.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Describes all available options.
}
\section{Request syntax}{
\preformatted{svc$describe_option_group_options(
  EngineName = "string",
  MajorEngineVersion = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
