% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_start_export_task}
\alias{rds_start_export_task}
\title{Starts an export of a snapshot to Amazon S3}
\usage{
rds_start_export_task(ExportTaskIdentifier, SourceArn, S3BucketName,
  IamRoleArn, KmsKeyId, S3Prefix, ExportOnly)
}
\arguments{
\item{ExportTaskIdentifier}{[required] A unique identifier for the snapshot export task. This ID isn't an
identifier for the Amazon S3 bucket where the snapshot is to be exported
to.}

\item{SourceArn}{[required] The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.}

\item{S3BucketName}{[required] The name of the Amazon S3 bucket to export the snapshot to.}

\item{IamRoleArn}{[required] The name of the IAM role to use for writing to the Amazon S3 bucket when
exporting a snapshot.}

\item{KmsKeyId}{[required] The ID of the AWS KMS customer master key (CMK) to use to encrypt the
snapshot exported to Amazon S3. The AWS KMS key identifier is the key
ARN, key ID, alias ARN, or alias name for the AWS KMS customer master
key (CMK). The caller of this operation must be authorized to execute
the following operations. These can be set in the AWS KMS key policy:
\itemize{
\item GrantOperation.Encrypt
\item GrantOperation.Decrypt
\item GrantOperation.GenerateDataKey
\item GrantOperation.GenerateDataKeyWithoutPlaintext
\item GrantOperation.ReEncryptFrom
\item GrantOperation.ReEncryptTo
\item GrantOperation.CreateGrant
\item GrantOperation.DescribeKey
\item GrantOperation.RetireGrant
}}

\item{S3Prefix}{The Amazon S3 bucket prefix to use as the file name and path of the
exported snapshot.}

\item{ExportOnly}{The data to be exported from the snapshot. If this parameter is not
provided, all the snapshot data is exported. Valid values are the
following:
\itemize{
\item \code{database} - Export all the data from a specified database.
\item \code{database.table} \emph{table-name} - Export a table of the snapshot. This
format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora
MySQL.
\item \code{database.schema} \emph{schema-name} - Export a database schema of the
snapshot. This format is valid only for RDS for PostgreSQL and
Aurora PostgreSQL.
\item \code{database.schema.table} \emph{table-name} - Export a table of the
database schema. This format is valid only for RDS for PostgreSQL
and Aurora PostgreSQL.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  ExportTaskIdentifier = "string",
  SourceArn = "string",
  ExportOnly = list(
    "string"
  ),
  SnapshotTime = as.POSIXct(
    "2015-01-01"
  ),
  TaskStartTime = as.POSIXct(
    "2015-01-01"
  ),
  TaskEndTime = as.POSIXct(
    "2015-01-01"
  ),
  S3Bucket = "string",
  S3Prefix = "string",
  IamRoleArn = "string",
  KmsKeyId = "string",
  Status = "string",
  PercentProgress = 123,
  TotalExtractedDataInGB = 123,
  FailureCause = "string",
  WarningMessage = "string"
)
}
}
\description{
Starts an export of a snapshot to Amazon S3. The provided IAM role must
have access to the S3 bucket.
}
\section{Request syntax}{
\preformatted{svc$start_export_task(
  ExportTaskIdentifier = "string",
  SourceArn = "string",
  S3BucketName = "string",
  IamRoleArn = "string",
  KmsKeyId = "string",
  S3Prefix = "string",
  ExportOnly = list(
    "string"
  )
)
}
}

\keyword{internal}
