% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_batch_modify_cluster_snapshots}
\alias{redshift_batch_modify_cluster_snapshots}
\title{Modifies the settings for a set of cluster snapshots}
\usage{
redshift_batch_modify_cluster_snapshots(SnapshotIdentifierList,
  ManualSnapshotRetentionPeriod, Force)
}
\arguments{
\item{SnapshotIdentifierList}{[required] A list of snapshot identifiers you want to modify.}

\item{ManualSnapshotRetentionPeriod}{The number of days that a manual snapshot is retained. If you specify
the value -1, the manual snapshot is retained indefinitely.

The number must be either -1 or an integer between 1 and 3,653.

If you decrease the manual snapshot retention period from its current
value, existing manual snapshots that fall outside of the new retention
period will return an error. If you want to suppress the errors and
delete the snapshots, use the force option.}

\item{Force}{A boolean value indicating whether to override an exception if the
retention period has passed.}
}
\value{
A list with the following syntax:\preformatted{list(
  Resources = list(
    "string"
  ),
  Errors = list(
    list(
      SnapshotIdentifier = "string",
      SnapshotClusterIdentifier = "string",
      FailureCode = "string",
      FailureReason = "string"
    )
  )
)
}
}
\description{
Modifies the settings for a set of cluster snapshots.
}
\section{Request syntax}{
\preformatted{svc$batch_modify_cluster_snapshots(
  SnapshotIdentifierList = list(
    "string"
  ),
  ManualSnapshotRetentionPeriod = 123,
  Force = TRUE|FALSE
)
}
}

\keyword{internal}
