% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_security_group}
\alias{rds_create_db_security_group}
\title{Creates a new DB security group}
\usage{
rds_create_db_security_group(DBSecurityGroupName,
  DBSecurityGroupDescription, Tags)
}
\arguments{
\item{DBSecurityGroupName}{[required] The name for the DB security group. This value is stored as a lowercase
string.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
\item Must not be "Default"
}

Example: \code{mysecuritygroup}}

\item{DBSecurityGroupDescription}{[required] The description for the DB security group.}

\item{Tags}{Tags to assign to the DB security group.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBSecurityGroup = list(
    OwnerId = "string",
    DBSecurityGroupName = "string",
    DBSecurityGroupDescription = "string",
    VpcId = "string",
    EC2SecurityGroups = list(
      list(
        Status = "string",
        EC2SecurityGroupName = "string",
        EC2SecurityGroupId = "string",
        EC2SecurityGroupOwnerId = "string"
      )
    ),
    IPRanges = list(
      list(
        Status = "string",
        CIDRIP = "string"
      )
    ),
    DBSecurityGroupArn = "string"
  )
)
}
}
\description{
Creates a new DB security group. DB security groups control access to a
DB instance.

A DB security group controls access to EC2-Classic DB instances that are
not in a VPC.
}
\section{Request syntax}{
\preformatted{svc$create_db_security_group(
  DBSecurityGroupName = "string",
  DBSecurityGroupDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
