% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_db_subnet_groups}
\alias{docdb_describe_db_subnet_groups}
\title{Returns a list of DBSubnetGroup descriptions}
\usage{
docdb_describe_db_subnet_groups(DBSubnetGroupName, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{DBSubnetGroupName}{The name of the subnet group to return details for.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  DBSubnetGroups = list(
    list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    )
  )
)
}
}
\description{
Returns a list of \code{DBSubnetGroup} descriptions. If a \code{DBSubnetGroupName}
is specified, the list will contain only the descriptions of the
specified \code{DBSubnetGroup}.
}
\section{Request syntax}{
\preformatted{svc$describe_db_subnet_groups(
  DBSubnetGroupName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
