% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dax_operations.R
\name{dax_delete_cluster}
\alias{dax_delete_cluster}
\title{Deletes a previously provisioned DAX cluster}
\usage{
dax_delete_cluster(ClusterName)
}
\arguments{
\item{ClusterName}{[required] The name of the cluster to be deleted.}
}
\value{
A list with the following syntax:\preformatted{list(
  Cluster = list(
    ClusterName = "string",
    Description = "string",
    ClusterArn = "string",
    TotalNodes = 123,
    ActiveNodes = 123,
    NodeType = "string",
    Status = "string",
    ClusterDiscoveryEndpoint = list(
      Address = "string",
      Port = 123
    ),
    NodeIdsToRemove = list(
      "string"
    ),
    Nodes = list(
      list(
        NodeId = "string",
        Endpoint = list(
          Address = "string",
          Port = 123
        ),
        NodeCreateTime = as.POSIXct(
          "2015-01-01"
        ),
        AvailabilityZone = "string",
        NodeStatus = "string",
        ParameterGroupStatus = "string"
      )
    ),
    PreferredMaintenanceWindow = "string",
    NotificationConfiguration = list(
      TopicArn = "string",
      TopicStatus = "string"
    ),
    SubnetGroup = "string",
    SecurityGroups = list(
      list(
        SecurityGroupIdentifier = "string",
        Status = "string"
      )
    ),
    IamRoleArn = "string",
    ParameterGroup = list(
      ParameterGroupName = "string",
      ParameterApplyStatus = "string",
      NodeIdsToReboot = list(
        "string"
      )
    ),
    SSEDescription = list(
      Status = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED"
    )
  )
)
}
}
\description{
Deletes a previously provisioned DAX cluster. \emph{DeleteCluster} deletes
all associated nodes, node endpoints and the DAX cluster itself. When
you receive a successful response from this action, DAX immediately
begins deleting the cluster; you cannot cancel or revert this action.
}
\section{Request syntax}{
\preformatted{svc$delete_cluster(
  ClusterName = "string"
)
}
}

\keyword{internal}
