% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_create_segment_snapshot}
\alias{customerprofiles_create_segment_snapshot}
\title{Triggers a job to export a segment to a specified destination}
\usage{
customerprofiles_create_segment_snapshot(
  DomainName,
  SegmentDefinitionName,
  DataFormat,
  EncryptionKey = NULL,
  RoleArn = NULL,
  DestinationUri = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{SegmentDefinitionName}{[required] The name of the segment definition used in this snapshot request.}

\item{DataFormat}{[required] The format in which the segment will be exported.}

\item{EncryptionKey}{The Amazon Resource Name (ARN) of the KMS key used to encrypt the
exported segment.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM role that allows Customer
Profiles service principal to assume the role for conducting KMS and S3
operations.}

\item{DestinationUri}{The destination to which the segment will be exported. This field must
be provided if the request is not submitted from the Amazon Connect
Admin Website.}
}
\description{
Triggers a job to export a segment to a specified destination.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_create_segment_snapshot/} for full documentation.
}
\keyword{internal}
