% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_send_destination_number_verification_code}
\alias{pinpointsmsvoicev2_send_destination_number_verification_code}
\title{Before you can send test messages to a verified destination phone number
you need to opt-in the verified destination phone number}
\usage{
pinpointsmsvoicev2_send_destination_number_verification_code(
  VerifiedDestinationNumberId,
  VerificationChannel,
  LanguageCode = NULL,
  OriginationIdentity = NULL,
  ConfigurationSetName = NULL,
  Context = NULL,
  DestinationCountryParameters = NULL
)
}
\arguments{
\item{VerifiedDestinationNumberId}{[required] The unique identifier for the verified destination phone number.}

\item{VerificationChannel}{[required] Choose to send the verification code as an SMS or voice message.}

\item{LanguageCode}{Choose the language to use for the message.}

\item{OriginationIdentity}{The origination identity of the message. This can be either the
PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn,
PoolId, or PoolArn.}

\item{ConfigurationSetName}{The name of the configuration set to use. This can be either the
ConfigurationSetName or ConfigurationSetArn.}

\item{Context}{You can specify custom data in this field. If you do, that data is
logged to the event destination.}

\item{DestinationCountryParameters}{This field is used for any country-specific registration requirements.
Currently, this setting is only used when you send messages to
recipients in India using a sender ID. For more information see \href{https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html}{Special requirements for sending SMS messages to recipients in India}.}
}
\description{
Before you can send test messages to a verified destination phone number you need to opt-in the verified destination phone number. Creates a new text message with a verification code and send it to a verified destination phone number. Once you have the verification code use \code{\link[=pinpointsmsvoicev2_verify_destination_number]{verify_destination_number}} to opt-in the verified destination phone number to receive messages.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_send_destination_number_verification_code/} for full documentation.
}
\keyword{internal}
