% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_verify_domain_dkim}
\alias{ses_verify_domain_dkim}
\title{Returns a set of DKIM tokens for a domain identity}
\usage{
ses_verify_domain_dkim(Domain)
}
\arguments{
\item{Domain}{[required] The name of the domain to be verified for Easy DKIM signing.}
}
\description{
Returns a set of DKIM tokens for a domain identity.
}
\details{
When you execute the \code{VerifyDomainDkim} operation, the domain that you
specify is added to the list of identities that are associated with your
account. This is true even if you haven\'t already associated the domain
with your account by using the \code{VerifyDomainIdentity} operation.
However, you can\'t send email from the domain until you either
successfully \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html}{verify it}
or you successfully \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html}{set up DKIM for it}.

You use the tokens that are generated by this operation to create CNAME
records. When Amazon SES detects that you\'ve added these records to the
DNS configuration for a domain, you can start sending email from that
domain. You can start sending email even if you haven\'t added the TXT
record provided by the VerifyDomainIdentity operation to the DNS
configuration for your domain. All email that you send from the domain
is authenticated using DKIM.

To create the CNAME records for DKIM authentication, use the following
values:
\itemize{
\item \strong{Name}: \emph{token}.\\_domainkey.\emph{example.com}
\item \strong{Type}: CNAME
\item \strong{Value}: \emph{token}.dkim.amazonses.com
}

In the preceding example, replace \emph{token} with one of the tokens that
are generated when you execute this operation. Replace \emph{example.com}
with your domain. Repeat this process for each token that\'s generated
by this operation.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$verify_domain_dkim(
  Domain = "string"
)
}
}

\examples{
\dontrun{
# The following example generates DKIM tokens for a domain that has been
# verified with Amazon SES:
svc$verify_domain_dkim(
  Domain = "example.com"
)
}

}
\keyword{internal}
