% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_create_configuration_set_tracking_options}
\alias{ses_create_configuration_set_tracking_options}
\title{Creates an association between a configuration set and a custom domain
for open and click event tracking}
\usage{
ses_create_configuration_set_tracking_options(ConfigurationSetName,
  TrackingOptions)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set that the tracking options should be
associated with.}

\item{TrackingOptions}{[required]}
}
\description{
Creates an association between a configuration set and a custom domain
for open and click event tracking.

By default, images and links used for tracking open and click events are
hosted on domains operated by Amazon SES. You can configure a subdomain
of your own to handle these events. For information about using custom
domains, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_configuration_set_tracking_options(
  ConfigurationSetName = "string",
  TrackingOptions = list(
    CustomRedirectDomain = "string"
  )
)
}
}

\keyword{internal}
