% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_contact_flows}
\alias{connect_list_contact_flows}
\title{Provides information about the contact flows for the specified Amazon
Connect instance}
\usage{
connect_list_contact_flows(InstanceId, ContactFlowTypes, NextToken,
  MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactFlowTypes}{The type of contact flow.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximimum number of results to return per page.}
}
\description{
Provides information about the contact flows for the specified Amazon
Connect instance.

You can also create and update contact flows using the \href{https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html}{Amazon Connect Flow language}.

For more information about contact flows, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html}{Contact Flows}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_contact_flows(
  InstanceId = "string",
  ContactFlowTypes = list(
    "CONTACT_FLOW"|"CUSTOMER_QUEUE"|"CUSTOMER_HOLD"|"CUSTOMER_WHISPER"|"AGENT_HOLD"|"AGENT_WHISPER"|"OUTBOUND_WHISPER"|"AGENT_TRANSFER"|"QUEUE_TRANSFER"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
