% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_current_metric_data}
\alias{connect_get_current_metric_data}
\title{The GetCurrentMetricData operation retrieves current metric data from
your Amazon Connect instance}
\usage{
connect_get_current_metric_data(InstanceId, Filters, Groupings,
  CurrentMetrics, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier for your Amazon Connect instance. To find the ID of your
instance, open the AWS console and select Amazon Connect. Select the
alias of the instance in the Instance alias column. The instance ID is
displayed in the Overview section of your instance settings. For
example, the instance ID is the set of characters at the end of the
instance ARN, after instance/, such as
10a4c4eb-f57e-4d4c-b602-bf39176ced07.}

\item{Filters}{[required] A \code{Filters} object that contains a list of queue IDs or queue ARNs, up
to 100, or list of Channels to use to filter the metrics returned in the
response. Metric data is retrieved only for the resources associated
with the queue IDs, ARNs, or Channels included in the filter. You can
include both IDs and ARNs in the same request. To retrieve metrics for
all queues, add the queue ID or ARN for each queue in your instance.
Only VOICE is supported for Channels.

To find the ARN for a queue, open the queue you want to use in the
Amazon Connect Queue editor. The ARN for the queue is displayed in the
address bar as part of the URL. For example, the queue ARN is the set of
characters at the end of the URL, after 'id=' such as
\code{arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61}.
The queue ID is also included in the URL, and is the string after
'queue/'.}

\item{Groupings}{The grouping applied to the metrics returned. For example, when grouped
by QUEUE, the metrics returned apply to each queue rather than
aggregated for all queues. If you group by CHANNEL, you should include a
Channels filter. The only supported channel is VOICE.

If no \code{Grouping} is included in the request, a summary of
\code{CurrentMetrics} is returned.}

\item{CurrentMetrics}{[required] A list of \code{CurrentMetric} objects for the metrics to retrieve. Each
\code{CurrentMetric} includes a name of a metric to retrieve and the unit to
use for it. You must list each metric to retrieve data for in the
request.

The following metrics are available:

AGENTS\_AVAILABLE

:   Unit: COUNT

AGENTS\_ONLINE

:   Unit: COUNT

AGENTS\_ON\_CALL

:   Unit: COUNT

AGENTS\_STAFFED

:   Unit: COUNT

AGENTS\_AFTER\_CONTACT\_WORK

:   Unit: COUNT

AGENTS\_NON\_PRODUCTIVE

:   Unit: COUNT

AGENTS\_ERROR

:   Unit: COUNT

CONTACTS\_IN\_QUEUE

:   Unit: COUNT

OLDEST\_CONTACT\_AGE

:   Unit: SECONDS

CONTACTS\_SCHEDULED

:   Unit: COUNT}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.

The token expires after 5 minutes from the time it is created.
Subsequent requests that use the \url{NextToken} must use the same request
parameters as the request that generated the token.}

\item{MaxResults}{\code{MaxResults} indicates the maximum number of results to return per page
in the response, between 1 and 100.}
}
\description{
The \code{GetCurrentMetricData} operation retrieves current metric data from
your Amazon Connect instance.
}
\details{
If you are using an IAM account, it must have permission to the
\code{connect:GetCurrentMetricData} action.
}
\section{Request syntax}{
\preformatted{svc$get_current_metric_data(
  InstanceId = "string",
  Filters = list(
    Queues = list(
      "string"
    ),
    Channels = list(
      "VOICE"
    )
  ),
  Groupings = list(
    "QUEUE"|"CHANNEL"
  ),
  CurrentMetrics = list(
    list(
      Name = "AGENTS_ONLINE"|"AGENTS_AVAILABLE"|"AGENTS_ON_CALL"|"AGENTS_NON_PRODUCTIVE"|"AGENTS_AFTER_CONTACT_WORK"|"AGENTS_ERROR"|"AGENTS_STAFFED"|"CONTACTS_IN_QUEUE"|"OLDEST_CONTACT_AGE"|"CONTACTS_SCHEDULED",
      Unit = "SECONDS"|"COUNT"|"PERCENT"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
