# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Price List Service
#'
#' @description
#' The Amazon Web Services Price List API is a centralized and convenient
#' way to programmatically query Amazon Web Services for services,
#' products, and pricing information. The Amazon Web Services Price List
#' uses standardized product attributes such as `Location`,
#' `Storage Class`, and `Operating System`, and provides prices at the SKU
#' level. You can use the Amazon Web Services Price List to do the
#' following:
#' 
#' -   Build cost control and scenario planning tools
#' 
#' -   Reconcile billing data
#' 
#' -   Forecast future spend for budgeting purposes
#' 
#' -   Provide cost benefit analysis that compare your internal workloads
#'     with Amazon Web Services
#' 
#' Use `GetServices` without a service code to retrieve the service codes
#' for all Amazon Web Services services, then `GetServices` with a service
#' code to retrieve the attribute names for that service. After you have
#' the service code and attribute names, you can use
#' [`get_attribute_values`][pricing_get_attribute_values] to see what
#' values are available for an attribute. With the service code and an
#' attribute name and value, you can use
#' [`get_products`][pricing_get_products] to find specific products that
#' you're interested in, such as an `AmazonEC2` instance, with a
#' `Provisioned IOPS` `volumeType`.
#' 
#' For more information, see [Using the Amazon Web Services Price List
#' API](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html)
#' in the *Billing User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- pricing(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- pricing()
#' # Retrieves the service for the given Service Code.
#' svc$describe_services(
#'   FormatVersion = "aws_v1",
#'   MaxResults = 1L,
#'   ServiceCode = "AmazonEC2"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=pricing_describe_services]{describe_services} \tab Returns the metadata for one service or a list of the metadata for all services\cr
#'  \link[=pricing_get_attribute_values]{get_attribute_values} \tab Returns a list of attribute values\cr
#'  \link[=pricing_get_price_list_file_url]{get_price_list_file_url} \tab This feature is in preview release and is subject to change\cr
#'  \link[=pricing_get_products]{get_products} \tab Returns a list of all products that match the filter criteria\cr
#'  \link[=pricing_list_price_lists]{list_price_lists} \tab This feature is in preview release and is subject to change
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname pricing
#' @export
pricing <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .pricing$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.pricing <- list()

.pricing$operations <- list()

.pricing$metadata <- list(
  service_name = "api.pricing",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "api.pricing.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Pricing",
  api_version = "2017-10-15",
  signing_name = "pricing",
  json_version = "1.1",
  target_prefix = "AWSPriceListService"
)

.pricing$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.pricing$metadata, handlers, config, op)
}
