% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacecatalog_operations.R
\name{marketplacecatalog_start_change_set}
\alias{marketplacecatalog_start_change_set}
\title{Allows you to request changes for your entities}
\usage{
marketplacecatalog_start_change_set(
  Catalog,
  ChangeSet,
  ChangeSetName = NULL,
  ClientRequestToken = NULL,
  ChangeSetTags = NULL,
  Intent = NULL
)
}
\arguments{
\item{Catalog}{[required] The catalog related to the request. Fixed value: \code{AWSMarketplace}}

\item{ChangeSet}{[required] Array of \code{change} object.}

\item{ChangeSetName}{Optional case sensitive string of up to 100 ASCII characters. The change
set name can be used to filter the list of change sets.}

\item{ClientRequestToken}{A unique token to identify the request to ensure idempotency.}

\item{ChangeSetTags}{A list of objects specifying each key name and value for the
\code{ChangeSetTags} property.}

\item{Intent}{The intent related to the request. The default is \code{APPLY}. To test your
request before applying changes to your entities, use \code{VALIDATE}. This
feature is currently available for adding versions to single-AMI
products. For more information, see \href{https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#ami-add-version}{Add a new version}.}
}
\description{
Allows you to request changes for your entities. Within a single \code{ChangeSet}, you can't start the same change type against the same entity multiple times. Additionally, when a \code{ChangeSet} is running, all the entities targeted by the different changes are locked until the change set has completed (either succeeded, cancelled, or failed). If you try to start a change set containing a change against an entity that is already locked, you will receive a \code{ResourceInUseException} error.

See \url{https://www.paws-r-sdk.com/docs/marketplacecatalog_start_change_set/} for full documentation.
}
\keyword{internal}
