# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include billingconductor_service.R
NULL

#' Connects an array of account IDs in a consolidated billing family to a
#' predefined billing group
#'
#' @description
#' Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_associate_accounts/](https://www.paws-r-sdk.com/docs/billingconductor_associate_accounts/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the billing group that associates the
#' array of account IDs.
#' @param AccountIds &#91;required&#93; The associating array of account IDs.
#'
#' @keywords internal
#'
#' @rdname billingconductor_associate_accounts
billingconductor_associate_accounts <- function(Arn, AccountIds) {
  op <- new_operation(
    name = "AssociateAccounts",
    http_method = "POST",
    http_path = "/associate-accounts",
    paginator = list()
  )
  input <- .billingconductor$associate_accounts_input(Arn = Arn, AccountIds = AccountIds)
  output <- .billingconductor$associate_accounts_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$associate_accounts <- billingconductor_associate_accounts

#' Connects an array of PricingRuleArns to a defined PricingPlan
#'
#' @description
#' Connects an array of `PricingRuleArns` to a defined `PricingPlan`. The maximum number `PricingRuleArn` that can be associated in one call is 30.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_associate_pricing_rules/](https://www.paws-r-sdk.com/docs/billingconductor_associate_pricing_rules/) for full documentation.
#'
#' @param Arn &#91;required&#93; The `PricingPlanArn` that the `PricingRuleArns` are associated with.
#' @param PricingRuleArns &#91;required&#93; The `PricingRuleArns` that are associated with the Pricing Plan.
#'
#' @keywords internal
#'
#' @rdname billingconductor_associate_pricing_rules
billingconductor_associate_pricing_rules <- function(Arn, PricingRuleArns) {
  op <- new_operation(
    name = "AssociatePricingRules",
    http_method = "PUT",
    http_path = "/associate-pricing-rules",
    paginator = list()
  )
  input <- .billingconductor$associate_pricing_rules_input(Arn = Arn, PricingRuleArns = PricingRuleArns)
  output <- .billingconductor$associate_pricing_rules_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$associate_pricing_rules <- billingconductor_associate_pricing_rules

#' Associates a batch of resources to a percentage custom line item
#'
#' @description
#' Associates a batch of resources to a percentage custom line item.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_batch_associate_resources_to_custom_line_item/](https://www.paws-r-sdk.com/docs/billingconductor_batch_associate_resources_to_custom_line_item/) for full documentation.
#'
#' @param TargetArn &#91;required&#93; A percentage custom line item ARN to associate the resources to.
#' @param ResourceArns &#91;required&#93; A list containing the ARNs of the resources to be associated.
#' @param BillingPeriodRange 
#'
#' @keywords internal
#'
#' @rdname billingconductor_batch_assoc_resou_to_custo_line_item
billingconductor_batch_associate_resources_to_custom_line_item <- function(TargetArn, ResourceArns, BillingPeriodRange = NULL) {
  op <- new_operation(
    name = "BatchAssociateResourcesToCustomLineItem",
    http_method = "PUT",
    http_path = "/batch-associate-resources-to-custom-line-item",
    paginator = list()
  )
  input <- .billingconductor$batch_associate_resources_to_custom_line_item_input(TargetArn = TargetArn, ResourceArns = ResourceArns, BillingPeriodRange = BillingPeriodRange)
  output <- .billingconductor$batch_associate_resources_to_custom_line_item_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$batch_associate_resources_to_custom_line_item <- billingconductor_batch_associate_resources_to_custom_line_item

#' Disassociates a batch of resources from a percentage custom line item
#'
#' @description
#' Disassociates a batch of resources from a percentage custom line item.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_batch_disassociate_resources_from_custom_line_item/](https://www.paws-r-sdk.com/docs/billingconductor_batch_disassociate_resources_from_custom_line_item/) for full documentation.
#'
#' @param TargetArn &#91;required&#93; A percentage custom line item ARN to disassociate the resources from.
#' @param ResourceArns &#91;required&#93; A list containing the ARNs of resources to be disassociated.
#' @param BillingPeriodRange 
#'
#' @keywords internal
#'
#' @rdname billingconductor_batch_disas_resou_from_custo_line_item
billingconductor_batch_disassociate_resources_from_custom_line_item <- function(TargetArn, ResourceArns, BillingPeriodRange = NULL) {
  op <- new_operation(
    name = "BatchDisassociateResourcesFromCustomLineItem",
    http_method = "PUT",
    http_path = "/batch-disassociate-resources-from-custom-line-item",
    paginator = list()
  )
  input <- .billingconductor$batch_disassociate_resources_from_custom_line_item_input(TargetArn = TargetArn, ResourceArns = ResourceArns, BillingPeriodRange = BillingPeriodRange)
  output <- .billingconductor$batch_disassociate_resources_from_custom_line_item_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$batch_disassociate_resources_from_custom_line_item <- billingconductor_batch_disassociate_resources_from_custom_line_item

#' Creates a billing group that resembles a consolidated billing family
#' that Amazon Web Services charges, based off of the predefined pricing
#' plan computation
#'
#' @description
#' Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_create_billing_group/](https://www.paws-r-sdk.com/docs/billingconductor_create_billing_group/) for full documentation.
#'
#' @param ClientToken The token that is needed to support idempotency. Idempotency isn't
#' currently supported, but will be implemented in a future update.
#' @param Name &#91;required&#93; The billing group name. The names must be unique.
#' @param AccountGrouping &#91;required&#93; The set of accounts that will be under the billing group. The set of
#' accounts resemble the linked accounts in a consolidated billing family.
#' @param ComputationPreference &#91;required&#93; The preferences and settings that will be used to compute the Amazon Web
#' Services charges for a billing group.
#' @param PrimaryAccountId The account ID that serves as the main account in a billing group.
#' @param Description The description of the billing group.
#' @param Tags A map that contains tag keys and tag values that are attached to a
#' billing group. This feature isn't available during the beta.
#'
#' @keywords internal
#'
#' @rdname billingconductor_create_billing_group
billingconductor_create_billing_group <- function(ClientToken = NULL, Name, AccountGrouping, ComputationPreference, PrimaryAccountId = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateBillingGroup",
    http_method = "POST",
    http_path = "/create-billing-group",
    paginator = list()
  )
  input <- .billingconductor$create_billing_group_input(ClientToken = ClientToken, Name = Name, AccountGrouping = AccountGrouping, ComputationPreference = ComputationPreference, PrimaryAccountId = PrimaryAccountId, Description = Description, Tags = Tags)
  output <- .billingconductor$create_billing_group_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$create_billing_group <- billingconductor_create_billing_group

#' Creates a custom line item that can be used to create a one-time fixed
#' charge that can be applied to a single billing group for the current or
#' previous billing period
#'
#' @description
#' Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_create_custom_line_item/](https://www.paws-r-sdk.com/docs/billingconductor_create_custom_line_item/) for full documentation.
#'
#' @param ClientToken The token that is needed to support idempotency. Idempotency isn't
#' currently supported, but will be implemented in a future update.
#' @param Name &#91;required&#93; The name of the custom line item.
#' @param Description &#91;required&#93; The description of the custom line item. This is shown on the Bills page
#' in association with the charge value.
#' @param BillingGroupArn &#91;required&#93; The Amazon Resource Name (ARN) that references the billing group where
#' the custom line item applies to.
#' @param BillingPeriodRange A time range for which the custom line item is effective.
#' @param Tags A map that contains tag keys and tag values that are attached to a
#' custom line item.
#' @param ChargeDetails &#91;required&#93; A `CustomLineItemChargeDetails` that describes the charge details for a
#' custom line item.
#'
#' @keywords internal
#'
#' @rdname billingconductor_create_custom_line_item
billingconductor_create_custom_line_item <- function(ClientToken = NULL, Name, Description, BillingGroupArn, BillingPeriodRange = NULL, Tags = NULL, ChargeDetails) {
  op <- new_operation(
    name = "CreateCustomLineItem",
    http_method = "POST",
    http_path = "/create-custom-line-item",
    paginator = list()
  )
  input <- .billingconductor$create_custom_line_item_input(ClientToken = ClientToken, Name = Name, Description = Description, BillingGroupArn = BillingGroupArn, BillingPeriodRange = BillingPeriodRange, Tags = Tags, ChargeDetails = ChargeDetails)
  output <- .billingconductor$create_custom_line_item_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$create_custom_line_item <- billingconductor_create_custom_line_item

#' Creates a pricing plan that is used for computing Amazon Web Services
#' charges for billing groups
#'
#' @description
#' Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_create_pricing_plan/](https://www.paws-r-sdk.com/docs/billingconductor_create_pricing_plan/) for full documentation.
#'
#' @param ClientToken The token that is needed to support idempotency. Idempotency isn't
#' currently supported, but will be implemented in a future update.
#' @param Name &#91;required&#93; The name of the pricing plan. The names must be unique to each pricing
#' plan.
#' @param Description The description of the pricing plan.
#' @param PricingRuleArns A list of Amazon Resource Names (ARNs) that define the pricing plan
#' parameters.
#' @param Tags A map that contains tag keys and tag values that are attached to a
#' pricing plan.
#'
#' @keywords internal
#'
#' @rdname billingconductor_create_pricing_plan
billingconductor_create_pricing_plan <- function(ClientToken = NULL, Name, Description = NULL, PricingRuleArns = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePricingPlan",
    http_method = "POST",
    http_path = "/create-pricing-plan",
    paginator = list()
  )
  input <- .billingconductor$create_pricing_plan_input(ClientToken = ClientToken, Name = Name, Description = Description, PricingRuleArns = PricingRuleArns, Tags = Tags)
  output <- .billingconductor$create_pricing_plan_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$create_pricing_plan <- billingconductor_create_pricing_plan

#' Creates a pricing rule can be associated to a pricing plan, or a set of
#' pricing plans
#'
#' @description
#' Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_create_pricing_rule/](https://www.paws-r-sdk.com/docs/billingconductor_create_pricing_rule/) for full documentation.
#'
#' @param ClientToken The token that's needed to support idempotency. Idempotency isn't
#' currently supported, but will be implemented in a future update.
#' @param Name &#91;required&#93; The pricing rule name. The names must be unique to each pricing rule.
#' @param Description The pricing rule description.
#' @param Scope &#91;required&#93; The scope of pricing rule that indicates if it's globally applicable, or
#' it's service-specific.
#' @param Type &#91;required&#93; The type of pricing rule.
#' @param ModifierPercentage A percentage modifier that's applied on the public pricing rates.
#' @param Service If the `Scope` attribute is set to `SERVICE` or `SKU`, the attribute
#' indicates which service the `PricingRule` is applicable for.
#' @param Tags A map that contains tag keys and tag values that are attached to a
#' pricing rule.
#' @param BillingEntity The seller of services provided by Amazon Web Services, their
#' affiliates, or third-party providers selling services via Amazon Web
#' Services Marketplace.
#' @param Tiering The set of tiering configurations for the pricing rule.
#' @param UsageType Usage type is the unit that each service uses to measure the usage of a
#' specific type of resource.
#' 
#' If the `Scope` attribute is set to `SKU`, this attribute indicates which
#' usage type the `PricingRule` is modifying. For example,
#' `USW2-BoxUsage:m2.2xlarge` describes
#' an` M2 High Memory Double Extra Large` instance in the US West (Oregon)
#' Region.
#' 
#'     </p> 
#' @param Operation Operation is the specific Amazon Web Services action covered by this
#' line item. This describes the specific usage of the line item.
#' 
#' If the `Scope` attribute is set to `SKU`, this attribute indicates which
#' operation the `PricingRule` is modifying. For example, a value of
#' `RunInstances:0202` indicates the operation of running an Amazon EC2
#' instance.
#'
#' @keywords internal
#'
#' @rdname billingconductor_create_pricing_rule
billingconductor_create_pricing_rule <- function(ClientToken = NULL, Name, Description = NULL, Scope, Type, ModifierPercentage = NULL, Service = NULL, Tags = NULL, BillingEntity = NULL, Tiering = NULL, UsageType = NULL, Operation = NULL) {
  op <- new_operation(
    name = "CreatePricingRule",
    http_method = "POST",
    http_path = "/create-pricing-rule",
    paginator = list()
  )
  input <- .billingconductor$create_pricing_rule_input(ClientToken = ClientToken, Name = Name, Description = Description, Scope = Scope, Type = Type, ModifierPercentage = ModifierPercentage, Service = Service, Tags = Tags, BillingEntity = BillingEntity, Tiering = Tiering, UsageType = UsageType, Operation = Operation)
  output <- .billingconductor$create_pricing_rule_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$create_pricing_rule <- billingconductor_create_pricing_rule

#' Deletes a billing group
#'
#' @description
#' Deletes a billing group.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_delete_billing_group/](https://www.paws-r-sdk.com/docs/billingconductor_delete_billing_group/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the billing group that you're
#' deleting.
#'
#' @keywords internal
#'
#' @rdname billingconductor_delete_billing_group
billingconductor_delete_billing_group <- function(Arn) {
  op <- new_operation(
    name = "DeleteBillingGroup",
    http_method = "POST",
    http_path = "/delete-billing-group",
    paginator = list()
  )
  input <- .billingconductor$delete_billing_group_input(Arn = Arn)
  output <- .billingconductor$delete_billing_group_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$delete_billing_group <- billingconductor_delete_billing_group

#' Deletes the custom line item identified by the given ARN in the current,
#' or previous billing period
#'
#' @description
#' Deletes the custom line item identified by the given ARN in the current, or previous billing period.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_delete_custom_line_item/](https://www.paws-r-sdk.com/docs/billingconductor_delete_custom_line_item/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the custom line item to be deleted.
#' @param BillingPeriodRange 
#'
#' @keywords internal
#'
#' @rdname billingconductor_delete_custom_line_item
billingconductor_delete_custom_line_item <- function(Arn, BillingPeriodRange = NULL) {
  op <- new_operation(
    name = "DeleteCustomLineItem",
    http_method = "POST",
    http_path = "/delete-custom-line-item",
    paginator = list()
  )
  input <- .billingconductor$delete_custom_line_item_input(Arn = Arn, BillingPeriodRange = BillingPeriodRange)
  output <- .billingconductor$delete_custom_line_item_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$delete_custom_line_item <- billingconductor_delete_custom_line_item

#' Deletes a pricing plan
#'
#' @description
#' Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_delete_pricing_plan/](https://www.paws-r-sdk.com/docs/billingconductor_delete_pricing_plan/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pricing plan that you're deleting.
#'
#' @keywords internal
#'
#' @rdname billingconductor_delete_pricing_plan
billingconductor_delete_pricing_plan <- function(Arn) {
  op <- new_operation(
    name = "DeletePricingPlan",
    http_method = "POST",
    http_path = "/delete-pricing-plan",
    paginator = list()
  )
  input <- .billingconductor$delete_pricing_plan_input(Arn = Arn)
  output <- .billingconductor$delete_pricing_plan_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$delete_pricing_plan <- billingconductor_delete_pricing_plan

#' Deletes the pricing rule that's identified by the input Amazon Resource
#' Name (ARN)
#'
#' @description
#' Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_delete_pricing_rule/](https://www.paws-r-sdk.com/docs/billingconductor_delete_pricing_rule/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pricing rule that you are
#' deleting.
#'
#' @keywords internal
#'
#' @rdname billingconductor_delete_pricing_rule
billingconductor_delete_pricing_rule <- function(Arn) {
  op <- new_operation(
    name = "DeletePricingRule",
    http_method = "POST",
    http_path = "/delete-pricing-rule",
    paginator = list()
  )
  input <- .billingconductor$delete_pricing_rule_input(Arn = Arn)
  output <- .billingconductor$delete_pricing_rule_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$delete_pricing_rule <- billingconductor_delete_pricing_rule

#' Removes the specified list of account IDs from the given billing group
#'
#' @description
#' Removes the specified list of account IDs from the given billing group.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_disassociate_accounts/](https://www.paws-r-sdk.com/docs/billingconductor_disassociate_accounts/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the billing group that the array of
#' account IDs will disassociate from.
#' @param AccountIds &#91;required&#93; The array of account IDs to disassociate.
#'
#' @keywords internal
#'
#' @rdname billingconductor_disassociate_accounts
billingconductor_disassociate_accounts <- function(Arn, AccountIds) {
  op <- new_operation(
    name = "DisassociateAccounts",
    http_method = "POST",
    http_path = "/disassociate-accounts",
    paginator = list()
  )
  input <- .billingconductor$disassociate_accounts_input(Arn = Arn, AccountIds = AccountIds)
  output <- .billingconductor$disassociate_accounts_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$disassociate_accounts <- billingconductor_disassociate_accounts

#' Disassociates a list of pricing rules from a pricing plan
#'
#' @description
#' Disassociates a list of pricing rules from a pricing plan.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_disassociate_pricing_rules/](https://www.paws-r-sdk.com/docs/billingconductor_disassociate_pricing_rules/) for full documentation.
#'
#' @param Arn &#91;required&#93; The pricing plan Amazon Resource Name (ARN) to disassociate pricing
#' rules from.
#' @param PricingRuleArns &#91;required&#93; A list containing the Amazon Resource Name (ARN) of the pricing rules
#' that will be disassociated.
#'
#' @keywords internal
#'
#' @rdname billingconductor_disassociate_pricing_rules
billingconductor_disassociate_pricing_rules <- function(Arn, PricingRuleArns) {
  op <- new_operation(
    name = "DisassociatePricingRules",
    http_method = "PUT",
    http_path = "/disassociate-pricing-rules",
    paginator = list()
  )
  input <- .billingconductor$disassociate_pricing_rules_input(Arn = Arn, PricingRuleArns = PricingRuleArns)
  output <- .billingconductor$disassociate_pricing_rules_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$disassociate_pricing_rules <- billingconductor_disassociate_pricing_rules

#' This is a paginated call to list linked accounts that are linked to the
#' payer account for the specified time period
#'
#' @description
#' This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group that's associated with the linked account.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_account_associations/](https://www.paws-r-sdk.com/docs/billingconductor_list_account_associations/) for full documentation.
#'
#' @param BillingPeriod The preferred billing period to get account associations.
#' @param Filters The filter on the account ID of the linked account, or any of the
#' following:
#' 
#' `MONITORED`: linked accounts that are associated to billing groups.
#' 
#' `UNMONITORED`: linked accounts that aren't associated to billing groups.
#' 
#' `Billing Group Arn`: linked accounts that are associated to the provided
#' billing group Arn.
#' @param NextToken The pagination token that's used on subsequent calls to retrieve
#' accounts.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_account_associations
billingconductor_list_account_associations <- function(BillingPeriod = NULL, Filters = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAccountAssociations",
    http_method = "POST",
    http_path = "/list-account-associations",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "LinkedAccounts")
  )
  input <- .billingconductor$list_account_associations_input(BillingPeriod = BillingPeriod, Filters = Filters, NextToken = NextToken)
  output <- .billingconductor$list_account_associations_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_account_associations <- billingconductor_list_account_associations

#' A paginated call to retrieve a summary report of actual Amazon Web
#' Services charges and the calculated Amazon Web Services charges based on
#' the associated pricing plan of a billing group
#'
#' @description
#' A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_billing_group_cost_reports/](https://www.paws-r-sdk.com/docs/billingconductor_list_billing_group_cost_reports/) for full documentation.
#'
#' @param BillingPeriod The preferred billing period for your report.
#' @param MaxResults The maximum number of reports to retrieve.
#' @param NextToken The pagination token that's used on subsequent calls to get reports.
#' @param Filters A `ListBillingGroupCostReportsFilter` to specify billing groups to
#' retrieve reports from.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_billing_group_cost_reports
billingconductor_list_billing_group_cost_reports <- function(BillingPeriod = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListBillingGroupCostReports",
    http_method = "POST",
    http_path = "/list-billing-group-cost-reports",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "BillingGroupCostReports")
  )
  input <- .billingconductor$list_billing_group_cost_reports_input(BillingPeriod = BillingPeriod, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .billingconductor$list_billing_group_cost_reports_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_billing_group_cost_reports <- billingconductor_list_billing_group_cost_reports

#' A paginated call to retrieve a list of billing groups for the given
#' billing period
#'
#' @description
#' A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_billing_groups/](https://www.paws-r-sdk.com/docs/billingconductor_list_billing_groups/) for full documentation.
#'
#' @param BillingPeriod The preferred billing period to get billing groups.
#' @param MaxResults The maximum number of billing groups to retrieve.
#' @param NextToken The pagination token that's used on subsequent calls to get billing
#' groups.
#' @param Filters A `ListBillingGroupsFilter` that specifies the billing group and pricing
#' plan to retrieve billing group information.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_billing_groups
billingconductor_list_billing_groups <- function(BillingPeriod = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListBillingGroups",
    http_method = "POST",
    http_path = "/list-billing-groups",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "BillingGroups")
  )
  input <- .billingconductor$list_billing_groups_input(BillingPeriod = BillingPeriod, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .billingconductor$list_billing_groups_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_billing_groups <- billingconductor_list_billing_groups

#' A paginated call to get a list of all custom line item versions
#'
#' @description
#' A paginated call to get a list of all custom line item versions.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_custom_line_item_versions/](https://www.paws-r-sdk.com/docs/billingconductor_list_custom_line_item_versions/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) for the custom line item.
#' @param MaxResults The maximum number of custom line item versions to retrieve.
#' @param NextToken The pagination token that's used on subsequent calls to retrieve custom
#' line item versions.
#' @param Filters A `ListCustomLineItemVersionsFilter` that specifies the billing period
#' range in which the custom line item versions are applied.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_custom_line_item_versions
billingconductor_list_custom_line_item_versions <- function(Arn, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListCustomLineItemVersions",
    http_method = "POST",
    http_path = "/list-custom-line-item-versions",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CustomLineItemVersions")
  )
  input <- .billingconductor$list_custom_line_item_versions_input(Arn = Arn, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .billingconductor$list_custom_line_item_versions_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_custom_line_item_versions <- billingconductor_list_custom_line_item_versions

#' A paginated call to get a list of all custom line items (FFLIs) for the
#' given billing period
#'
#' @description
#' A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_custom_line_items/](https://www.paws-r-sdk.com/docs/billingconductor_list_custom_line_items/) for full documentation.
#'
#' @param BillingPeriod The preferred billing period to get custom line items (FFLIs).
#' @param MaxResults The maximum number of billing groups to retrieve.
#' @param NextToken The pagination token that's used on subsequent calls to get custom line
#' items (FFLIs).
#' @param Filters A `ListCustomLineItemsFilter` that specifies the custom line item names
#' and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI
#' information.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_custom_line_items
billingconductor_list_custom_line_items <- function(BillingPeriod = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListCustomLineItems",
    http_method = "POST",
    http_path = "/list-custom-line-items",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CustomLineItems")
  )
  input <- .billingconductor$list_custom_line_items_input(BillingPeriod = BillingPeriod, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .billingconductor$list_custom_line_items_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_custom_line_items <- billingconductor_list_custom_line_items

#' A paginated call to get pricing plans for the given billing period
#'
#' @description
#' A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_plans/](https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_plans/) for full documentation.
#'
#' @param BillingPeriod The preferred billing period to get pricing plan.
#' @param Filters A `ListPricingPlansFilter` that specifies the Amazon Resource Name
#' (ARNs) of pricing plans to retrieve pricing plans information.
#' @param MaxResults The maximum number of pricing plans to retrieve.
#' @param NextToken The pagination token that's used on subsequent call to get pricing
#' plans.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_pricing_plans
billingconductor_list_pricing_plans <- function(BillingPeriod = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPricingPlans",
    http_method = "POST",
    http_path = "/list-pricing-plans",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "BillingPeriod"), output_token = "NextToken", result_key = "PricingPlans")
  )
  input <- .billingconductor$list_pricing_plans_input(BillingPeriod = BillingPeriod, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .billingconductor$list_pricing_plans_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_pricing_plans <- billingconductor_list_pricing_plans

#' A list of the pricing plans that are associated with a pricing rule
#'
#' @description
#' A list of the pricing plans that are associated with a pricing rule.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_plans_associated_with_pricing_rule/](https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_plans_associated_with_pricing_rule/) for full documentation.
#'
#' @param BillingPeriod The pricing plan billing period for which associations will be listed.
#' @param PricingRuleArn &#91;required&#93; The pricing rule Amazon Resource Name (ARN) for which associations will
#' be listed.
#' @param MaxResults The optional maximum number of pricing rule associations to retrieve.
#' @param NextToken The optional pagination token returned by a previous call.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_prici_plans_assoc_with_prici_rule
billingconductor_list_pricing_plans_associated_with_pricing_rule <- function(BillingPeriod = NULL, PricingRuleArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPricingPlansAssociatedWithPricingRule",
    http_method = "POST",
    http_path = "/list-pricing-plans-associated-with-pricing-rule",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "BillingPeriod", "PricingRuleArn"), output_token = "NextToken", result_key = "PricingPlanArns")
  )
  input <- .billingconductor$list_pricing_plans_associated_with_pricing_rule_input(BillingPeriod = BillingPeriod, PricingRuleArn = PricingRuleArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .billingconductor$list_pricing_plans_associated_with_pricing_rule_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_pricing_plans_associated_with_pricing_rule <- billingconductor_list_pricing_plans_associated_with_pricing_rule

#' Describes a pricing rule that can be associated to a pricing plan, or
#' set of pricing plans
#'
#' @description
#' Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_rules/](https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_rules/) for full documentation.
#'
#' @param BillingPeriod The preferred billing period to get the pricing plan.
#' @param Filters A `DescribePricingRuleFilter` that specifies the Amazon Resource Name
#' (ARNs) of pricing rules to retrieve pricing rules information.
#' @param MaxResults The maximum number of pricing rules to retrieve.
#' @param NextToken The pagination token that's used on subsequent call to get pricing
#' rules.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_pricing_rules
billingconductor_list_pricing_rules <- function(BillingPeriod = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPricingRules",
    http_method = "POST",
    http_path = "/list-pricing-rules",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "BillingPeriod"), output_token = "NextToken", result_key = "PricingRules")
  )
  input <- .billingconductor$list_pricing_rules_input(BillingPeriod = BillingPeriod, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .billingconductor$list_pricing_rules_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_pricing_rules <- billingconductor_list_pricing_rules

#' Lists the pricing rules that are associated with a pricing plan
#'
#' @description
#' Lists the pricing rules that are associated with a pricing plan.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_rules_associated_to_pricing_plan/](https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_rules_associated_to_pricing_plan/) for full documentation.
#'
#' @param BillingPeriod The billing period for which the pricing rule associations are to be
#' listed.
#' @param PricingPlanArn &#91;required&#93; The Amazon Resource Name (ARN) of the pricing plan for which
#' associations are to be listed.
#' @param MaxResults The optional maximum number of pricing rule associations to retrieve.
#' @param NextToken The optional pagination token returned by a previous call.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_prici_rules_assoc_to_prici_plan
billingconductor_list_pricing_rules_associated_to_pricing_plan <- function(BillingPeriod = NULL, PricingPlanArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPricingRulesAssociatedToPricingPlan",
    http_method = "POST",
    http_path = "/list-pricing-rules-associated-to-pricing-plan",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "BillingPeriod", "PricingPlanArn"), output_token = "NextToken", result_key = "PricingRuleArns")
  )
  input <- .billingconductor$list_pricing_rules_associated_to_pricing_plan_input(BillingPeriod = BillingPeriod, PricingPlanArn = PricingPlanArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .billingconductor$list_pricing_rules_associated_to_pricing_plan_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_pricing_rules_associated_to_pricing_plan <- billingconductor_list_pricing_rules_associated_to_pricing_plan

#' List the resources that are associated to a custom line item
#'
#' @description
#' List the resources that are associated to a custom line item.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_resources_associated_to_custom_line_item/](https://www.paws-r-sdk.com/docs/billingconductor_list_resources_associated_to_custom_line_item/) for full documentation.
#'
#' @param BillingPeriod The billing period for which the resource associations will be listed.
#' @param Arn &#91;required&#93; The ARN of the custom line item for which the resource associations will
#' be listed.
#' @param MaxResults (Optional) The maximum number of resource associations to be retrieved.
#' @param NextToken (Optional) The pagination token that's returned by a previous request.
#' @param Filters (Optional) A `ListResourcesAssociatedToCustomLineItemFilter` that can
#' specify the types of resources that should be retrieved.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_resou_assoc_to_custo_line_item
billingconductor_list_resources_associated_to_custom_line_item <- function(BillingPeriod = NULL, Arn, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResourcesAssociatedToCustomLineItem",
    http_method = "POST",
    http_path = "/list-resources-associated-to-custom-line-item",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "Arn"), output_token = "NextToken", result_key = "AssociatedResources")
  )
  input <- .billingconductor$list_resources_associated_to_custom_line_item_input(BillingPeriod = BillingPeriod, Arn = Arn, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .billingconductor$list_resources_associated_to_custom_line_item_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_resources_associated_to_custom_line_item <- billingconductor_list_resources_associated_to_custom_line_item

#' A list the tags for a resource
#'
#' @description
#' A list the tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/billingconductor_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags.
#'
#' @keywords internal
#'
#' @rdname billingconductor_list_tags_for_resource
billingconductor_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .billingconductor$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .billingconductor$list_tags_for_resource_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$list_tags_for_resource <- billingconductor_list_tags_for_resource

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_tag_resource/](https://www.paws-r-sdk.com/docs/billingconductor_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which to add tags.
#' @param Tags &#91;required&#93; The tags to add to the resource as a list of key-value pairs.
#'
#' @keywords internal
#'
#' @rdname billingconductor_tag_resource
billingconductor_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .billingconductor$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .billingconductor$tag_resource_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$tag_resource <- billingconductor_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_untag_resource/](https://www.paws-r-sdk.com/docs/billingconductor_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which to delete tags.
#' @param TagKeys &#91;required&#93; The tags to delete from the resource as a list of key-value pairs.
#'
#' @keywords internal
#'
#' @rdname billingconductor_untag_resource
billingconductor_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .billingconductor$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .billingconductor$untag_resource_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$untag_resource <- billingconductor_untag_resource

#' This updates an existing billing group
#'
#' @description
#' This updates an existing billing group.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_update_billing_group/](https://www.paws-r-sdk.com/docs/billingconductor_update_billing_group/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the billing group being updated.
#' @param Name The name of the billing group. The names must be unique to each billing
#' group.
#' @param Status The status of the billing group. Only one of the valid values can be
#' used.
#' @param ComputationPreference The preferences and settings that will be used to compute the Amazon Web
#' Services charges for a billing group.
#' @param Description A description of the billing group.
#' @param AccountGrouping Specifies if the billing group has automatic account association
#' (`AutoAssociate`) enabled.
#'
#' @keywords internal
#'
#' @rdname billingconductor_update_billing_group
billingconductor_update_billing_group <- function(Arn, Name = NULL, Status = NULL, ComputationPreference = NULL, Description = NULL, AccountGrouping = NULL) {
  op <- new_operation(
    name = "UpdateBillingGroup",
    http_method = "POST",
    http_path = "/update-billing-group",
    paginator = list()
  )
  input <- .billingconductor$update_billing_group_input(Arn = Arn, Name = Name, Status = Status, ComputationPreference = ComputationPreference, Description = Description, AccountGrouping = AccountGrouping)
  output <- .billingconductor$update_billing_group_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$update_billing_group <- billingconductor_update_billing_group

#' Update an existing custom line item in the current or previous billing
#' period
#'
#' @description
#' Update an existing custom line item in the current or previous billing period.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_update_custom_line_item/](https://www.paws-r-sdk.com/docs/billingconductor_update_custom_line_item/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the custom line item to be updated.
#' @param Name The new name for the custom line item.
#' @param Description The new line item description of the custom line item.
#' @param ChargeDetails A `ListCustomLineItemChargeDetails` containing the new charge details
#' for the custom line item.
#' @param BillingPeriodRange 
#'
#' @keywords internal
#'
#' @rdname billingconductor_update_custom_line_item
billingconductor_update_custom_line_item <- function(Arn, Name = NULL, Description = NULL, ChargeDetails = NULL, BillingPeriodRange = NULL) {
  op <- new_operation(
    name = "UpdateCustomLineItem",
    http_method = "POST",
    http_path = "/update-custom-line-item",
    paginator = list()
  )
  input <- .billingconductor$update_custom_line_item_input(Arn = Arn, Name = Name, Description = Description, ChargeDetails = ChargeDetails, BillingPeriodRange = BillingPeriodRange)
  output <- .billingconductor$update_custom_line_item_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$update_custom_line_item <- billingconductor_update_custom_line_item

#' This updates an existing pricing plan
#'
#' @description
#' This updates an existing pricing plan.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_update_pricing_plan/](https://www.paws-r-sdk.com/docs/billingconductor_update_pricing_plan/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pricing plan that you're updating.
#' @param Name The name of the pricing plan. The name must be unique to each pricing
#' plan.
#' @param Description The description of the pricing plan.
#'
#' @keywords internal
#'
#' @rdname billingconductor_update_pricing_plan
billingconductor_update_pricing_plan <- function(Arn, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdatePricingPlan",
    http_method = "PUT",
    http_path = "/update-pricing-plan",
    paginator = list()
  )
  input <- .billingconductor$update_pricing_plan_input(Arn = Arn, Name = Name, Description = Description)
  output <- .billingconductor$update_pricing_plan_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$update_pricing_plan <- billingconductor_update_pricing_plan

#' Updates an existing pricing rule
#'
#' @description
#' Updates an existing pricing rule.
#'
#' See [https://www.paws-r-sdk.com/docs/billingconductor_update_pricing_rule/](https://www.paws-r-sdk.com/docs/billingconductor_update_pricing_rule/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pricing rule to update.
#' @param Name The new name of the pricing rule. The name must be unique to each
#' pricing rule.
#' @param Description The new description for the pricing rule.
#' @param Type The new pricing rule type.
#' @param ModifierPercentage The new modifier to show pricing plan rates as a percentage.
#' @param Tiering The set of tiering configurations for the pricing rule.
#'
#' @keywords internal
#'
#' @rdname billingconductor_update_pricing_rule
billingconductor_update_pricing_rule <- function(Arn, Name = NULL, Description = NULL, Type = NULL, ModifierPercentage = NULL, Tiering = NULL) {
  op <- new_operation(
    name = "UpdatePricingRule",
    http_method = "PUT",
    http_path = "/update-pricing-rule",
    paginator = list()
  )
  input <- .billingconductor$update_pricing_rule_input(Arn = Arn, Name = Name, Description = Description, Type = Type, ModifierPercentage = ModifierPercentage, Tiering = Tiering)
  output <- .billingconductor$update_pricing_rule_output()
  config <- get_config()
  svc <- .billingconductor$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.billingconductor$operations$update_pricing_rule <- billingconductor_update_pricing_rule
