% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_list_snapshots_in_recycle_bin}
\alias{ec2_list_snapshots_in_recycle_bin}
\title{Lists one or more snapshots that are currently in the Recycle Bin}
\usage{
ec2_list_snapshots_in_recycle_bin(
  MaxResults = NULL,
  NextToken = NULL,
  SnapshotIds = NULL,
  DryRun = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{SnapshotIds}{The IDs of the snapshots to list. Omit this parameter to list all of the
snapshots that are in the Recycle Bin.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Lists one or more snapshots that are currently in the Recycle Bin.

See \url{https://www.paws-r-sdk.com/docs/ec2_list_snapshots_in_recycle_bin/} for full documentation.
}
\keyword{internal}
