% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_function_event_invoke_config}
\alias{lambda_update_function_event_invoke_config}
\title{Updates the configuration for asynchronous invocation for a function,
version, or alias}
\usage{
lambda_update_function_event_invoke_config(
  FunctionName,
  Qualifier = NULL,
  MaximumRetryAttempts = NULL,
  MaximumEventAgeInSeconds = NULL,
  DestinationConfig = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{A version number or alias name.}

\item{MaximumRetryAttempts}{The maximum number of times to retry when the function returns an error.}

\item{MaximumEventAgeInSeconds}{The maximum age of a request that Lambda sends to a function for
processing.}

\item{DestinationConfig}{A destination for events after they have been sent to a function for
processing.

\strong{Destinations}
\itemize{
\item \strong{Function} - The Amazon Resource Name (ARN) of a Lambda function.
\item \strong{Queue} - The ARN of a standard SQS queue.
\item \strong{Topic} - The ARN of a standard SNS topic.
\item \strong{Event Bus} - The ARN of an Amazon EventBridge event bus.
}}
}
\description{
Updates the configuration for asynchronous invocation for a function, version, or alias.

See \url{https://www.paws-r-sdk.com/docs/lambda_update_function_event_invoke_config/} for full documentation.
}
\keyword{internal}
