% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_image_block_public_access}
\alias{ec2_enable_image_block_public_access}
\title{Enables block public access for AMIs at the account level in the
specified Amazon Web Services Region}
\usage{
ec2_enable_image_block_public_access(
  ImageBlockPublicAccessState,
  DryRun = NULL
)
}
\arguments{
\item{ImageBlockPublicAccessState}{[required] Specify \code{block-new-sharing} to enable block public access for AMIs at
the account level in the specified Region. This will block any attempt
to publicly share your AMIs in the specified Region.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Enables \emph{block public access for AMIs} at the account level in the specified Amazon Web Services Region. This prevents the public sharing of your AMIs. However, if you already have public AMIs, they will remain publicly available.

See \url{https://www.paws-r-sdk.com/docs/ec2_enable_image_block_public_access/} for full documentation.
}
\keyword{internal}
