% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_authorize_security_group_egress}
\alias{ec2_authorize_security_group_egress}
\title{Adds the specified outbound (egress) rules to a security group for use
with a VPC}
\usage{
ec2_authorize_security_group_egress(
  DryRun = NULL,
  GroupId,
  IpPermissions = NULL,
  TagSpecifications = NULL,
  CidrIp = NULL,
  FromPort = NULL,
  IpProtocol = NULL,
  ToPort = NULL,
  SourceSecurityGroupName = NULL,
  SourceSecurityGroupOwnerId = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{[required] The ID of the security group.}

\item{IpPermissions}{The sets of IP permissions. You can't specify a destination security
group and a CIDR IP address range in the same set of permissions.}

\item{TagSpecifications}{The tags applied to the security group rule.}

\item{CidrIp}{Not supported. Use a set of IP permissions to specify the CIDR.}

\item{FromPort}{Not supported. Use a set of IP permissions to specify the port.}

\item{IpProtocol}{Not supported. Use a set of IP permissions to specify the protocol name
or number.}

\item{ToPort}{Not supported. Use a set of IP permissions to specify the port.}

\item{SourceSecurityGroupName}{Not supported. Use a set of IP permissions to specify a destination
security group.}

\item{SourceSecurityGroupOwnerId}{Not supported. Use a set of IP permissions to specify a destination
security group.}
}
\description{
Adds the specified outbound (egress) rules to a security group for use with a VPC.

See \url{https://www.paws-r-sdk.com/docs/ec2_authorize_security_group_egress/} for full documentation.
}
\keyword{internal}
