% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_address_history}
\alias{ec2_get_ipam_address_history}
\title{Retrieve historical information about a CIDR within an IPAM scope}
\usage{
ec2_get_ipam_address_history(
  DryRun = NULL,
  Cidr,
  IpamScopeId,
  VpcId = NULL,
  StartTime = NULL,
  EndTime = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{Cidr}{[required] The CIDR you want the history of. The CIDR can be an IPv4 or IPv6 IP
address range. If you enter a /16 IPv4 CIDR, you will get records that
match it exactly. You will not get records for any subnets within the
/16 CIDR.}

\item{IpamScopeId}{[required] The ID of the IPAM scope that the CIDR is in.}

\item{VpcId}{The ID of the VPC you want your history records filtered by.}

\item{StartTime}{The start of the time period for which you are looking for history. If
you omit this option, it will default to the value of EndTime.}

\item{EndTime}{The end of the time period for which you are looking for history. If you
omit this option, it will default to the current time.}

\item{MaxResults}{The maximum number of historical results you would like returned per
page. Defaults to 100.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Retrieve historical information about a CIDR within an IPAM scope. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/view-history-cidr-ipam.html}{View the history of IP addresses} in the \emph{Amazon VPC IPAM User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_ipam_address_history/} for full documentation.
}
\keyword{internal}
