% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braket_operations.R
\name{braket_create_quantum_task}
\alias{braket_create_quantum_task}
\title{Creates a quantum task}
\usage{
braket_create_quantum_task(
  action,
  clientToken,
  deviceArn,
  deviceParameters = NULL,
  jobToken = NULL,
  outputS3Bucket,
  outputS3KeyPrefix,
  shots,
  tags = NULL
)
}
\arguments{
\item{action}{[required] The action associated with the task.}

\item{clientToken}{[required] The client token associated with the request.}

\item{deviceArn}{[required] The ARN of the device to run the task on.}

\item{deviceParameters}{The parameters for the device to run the task on.}

\item{jobToken}{The token for an Amazon Braket job that associates it with the quantum
task.}

\item{outputS3Bucket}{[required] The S3 bucket to store task result files in.}

\item{outputS3KeyPrefix}{[required] The key prefix for the location in the S3 bucket to store task results
in.}

\item{shots}{[required] The number of shots to use for the task.}

\item{tags}{Tags to be added to the quantum task you're creating.}
}
\description{
Creates a quantum task.

See \url{https://www.paws-r-sdk.com/docs/braket_create_quantum_task/} for full documentation.
}
\keyword{internal}
