% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_deregister_container_instance}
\alias{ecs_deregister_container_instance}
\title{Deregisters an Amazon ECS container instance from the specified cluster}
\usage{
ecs_deregister_container_instance(
  cluster = NULL,
  containerInstance,
  force = NULL
)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the container instance to deregister. If you do not specify a
cluster, the default cluster is assumed.}

\item{containerInstance}{[required] The container instance ID or full ARN of the container instance to
deregister. For more information about the ARN format, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids}{Amazon Resource Name (ARN)}
in the \emph{Amazon ECS Developer Guide}.}

\item{force}{Forces the container instance to be deregistered. If you have tasks
running on the container instance when you deregister it with the
\code{force} option, these tasks remain running until you terminate the
instance or the tasks stop through some other means, but they're
orphaned (no longer monitored or accounted for by Amazon ECS). If an
orphaned task on your container instance is part of an Amazon ECS
service, then the service scheduler starts another copy of that task, on
a different container instance if possible.

Any containers in orphaned service tasks that are registered with a
Classic Load Balancer or an Application Load Balancer target group are
deregistered. They begin connection draining according to the settings
on the load balancer or target group.}
}
\description{
Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to run tasks.

See \url{https://paws-r.github.io/docs/ecs/deregister_container_instance.html} for full documentation.
}
\keyword{internal}
