% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_create_application}
\alias{elasticbeanstalk_create_application}
\title{Creates an application that has one configuration template named default
and no application versions}
\usage{
elasticbeanstalk_create_application(ApplicationName, Description,
  ResourceLifecycleConfig, Tags)
}
\arguments{
\item{ApplicationName}{[required] The name of the application. Must be unique within your account.}

\item{Description}{Your description of the application.}

\item{ResourceLifecycleConfig}{Specifies an application resource lifecycle configuration to prevent
your application from accumulating too many versions.}

\item{Tags}{Specifies the tags applied to the application.

Elastic Beanstalk applies these tags only to the application.
Environments that you create in the application don\'t inherit the tags.}
}
\description{
Creates an application that has one configuration template named
\code{default} and no application versions.
}
\section{Request syntax}{
\preformatted{svc$create_application(
  ApplicationName = "string",
  Description = "string",
  ResourceLifecycleConfig = list(
    ServiceRole = "string",
    VersionLifecycleConfig = list(
      MaxCountRule = list(
        Enabled = TRUE|FALSE,
        MaxCount = 123,
        DeleteSourceFromS3 = TRUE|FALSE
      ),
      MaxAgeRule = list(
        Enabled = TRUE|FALSE,
        MaxAgeInDays = 123,
        DeleteSourceFromS3 = TRUE|FALSE
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following operation creates a new application named my-app:
svc$create_application(
  ApplicationName = "my-app",
  Description = "my application"
)
}

}
\keyword{internal}
