% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_delete_function}
\alias{lambda_delete_function}
\title{Deletes a Lambda function}
\usage{
lambda_delete_function(FunctionName, Qualifier)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function or version.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:1} (with
version).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{Specify a version to delete. You can\'t delete a version that\'s
referenced by an alias.}
}
\description{
Deletes a Lambda function. To delete a specific function version, use
the \code{Qualifier} parameter. Otherwise, all versions and aliases are
deleted.
}
\details{
To delete Lambda event source mappings that invoke a function, use
DeleteEventSourceMapping. For AWS services and resources that invoke
your function directly, delete the trigger in the service where you
originally configured it.
}
\section{Request syntax}{
\preformatted{svc$delete_function(
  FunctionName = "string",
  Qualifier = "string"
)
}
}

\examples{
# This operation deletes a Lambda function
\dontrun{svc$delete_function(
  FunctionName = "myFunction",
  Qualifier = "1"
)}

}
\keyword{internal}
