% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_update_configuration_template}
\alias{elasticbeanstalk_update_configuration_template}
\title{Updates the specified configuration template to have the specified
properties or configuration option values}
\usage{
elasticbeanstalk_update_configuration_template(ApplicationName,
  TemplateName, Description, OptionSettings, OptionsToRemove)
}
\arguments{
\item{ApplicationName}{[required] The name of the application associated with the configuration template
to update.

If no application is found with this name, \code{UpdateConfigurationTemplate}
returns an \code{InvalidParameterValue} error.}

\item{TemplateName}{[required] The name of the configuration template to update.

If no configuration template is found with this name,
\code{UpdateConfigurationTemplate} returns an \code{InvalidParameterValue} error.}

\item{Description}{A new description for the configuration.}

\item{OptionSettings}{A list of configuration option settings to update with the new specified
option value.}

\item{OptionsToRemove}{A list of configuration options to remove from the configuration set.

Constraint: You can remove only \code{UserDefined} configuration options.}
}
\description{
Updates the specified configuration template to have the specified
properties or configuration option values.
}
\details{
If a property (for example, \code{ApplicationName}) is not provided, its
value remains unchanged. To clear such properties, specify an empty
string.

Related Topics
\itemize{
\item DescribeConfigurationOptions
}
}
\section{Request syntax}{
\preformatted{svc$update_configuration_template(
  ApplicationName = "string",
  TemplateName = "string",
  Description = "string",
  OptionSettings = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string",
      Value = "string"
    )
  ),
  OptionsToRemove = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string"
    )
  )
)
}
}

\examples{
# The following operation removes the configured CloudWatch custom health
# metrics configuration ConfigDocument from a saved configuration template
# named my-template:
\dontrun{svc$update_configuration_template(
  ApplicationName = "my-app",
  OptionsToRemove = list(
    list(
      Namespace = "aws:elasticbeanstalk:healthreporting:system",
      OptionName = "ConfigDocument"
    )
  ),
  TemplateName = "my-template"
)}

}
\keyword{internal}
