% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_publish_layer_version}
\alias{lambda_publish_layer_version}
\title{Creates an AWS Lambda layer from a ZIP archive}
\usage{
lambda_publish_layer_version(LayerName, Description, Content,
  CompatibleRuntimes, LicenseInfo)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{Description}{The description of the version.}

\item{Content}{[required] The function layer archive.}

\item{CompatibleRuntimes}{A list of compatible \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{function runtimes}.
Used for filtering with ListLayers and ListLayerVersions.}

\item{LicenseInfo}{The layer's software license. It can be any of the following:
\itemize{
\item An \href{https://spdx.org/licenses/}{SPDX license identifier}. For
example, \code{MIT}.
\item The URL of a license hosted on the internet. For example,
\code{https://opensource.org/licenses/MIT}.
\item The full text of the license.
}}
}
\description{
Creates an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer}
from a ZIP archive. Each time you call \code{PublishLayerVersion} with the
same version name, a new version is created.
}
\details{
Add layers to your function with CreateFunction or
UpdateFunctionConfiguration.
}
\section{Request syntax}{
\preformatted{svc$publish_layer_version(
  LayerName = "string",
  Description = "string",
  Content = list(
    S3Bucket = "string",
    S3Key = "string",
    S3ObjectVersion = "string",
    ZipFile = raw
  ),
  CompatibleRuntimes = list(
    "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided"
  ),
  LicenseInfo = "string"
)
}
}

\keyword{internal}
