% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_nat_gateway}
\alias{ec2_delete_nat_gateway}
\title{Deletes the specified NAT gateway}
\usage{
ec2_delete_nat_gateway(NatGatewayId)
}
\arguments{
\item{NatGatewayId}{[required] The ID of the NAT gateway.}
}
\description{
Deletes the specified NAT gateway. Deleting a NAT gateway disassociates
its Elastic IP address, but does not release the address from your
account. Deleting a NAT gateway does not delete any NAT gateway routes
in your route tables.
}
\section{Request syntax}{
\preformatted{svc$delete_nat_gateway(
  NatGatewayId = "string"
)
}
}

\examples{
# This example deletes the specified NAT gateway.
\donttest{svc$delete_nat_gateway(
  NatGatewayId = "nat-04ae55e711cec5680"
)}

}
\keyword{internal}
