% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_add_permission}
\alias{lambda_add_permission}
\title{Grants an AWS service or another account permission to use a function}
\usage{
lambda_add_permission(FunctionName, StatementId, Action, Principal,
  SourceArn, SourceAccount, EventSourceToken, Qualifier, RevisionId)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{StatementId}{[required] A statement identifier that differentiates the statement from others in
the same policy.}

\item{Action}{[required] The action that the principal can use on the function. For example,
\code{lambda:InvokeFunction} or \code{lambda:GetFunction}.}

\item{Principal}{[required] The AWS service or account that invokes the function. If you specify a
service, use \code{SourceArn} or \code{SourceAccount} to limit who can invoke the
function through that service.}

\item{SourceArn}{For AWS services, the ARN of the AWS resource that invokes the function.
For example, an Amazon S3 bucket or Amazon SNS topic.}

\item{SourceAccount}{For Amazon S3, the ID of the account that owns the resource. Use this
together with \code{SourceArn} to ensure that the resource is owned by the
specified account. It is possible for an Amazon S3 bucket to be deleted
by its owner and recreated by another account.}

\item{EventSourceToken}{For Alexa Smart Home functions, a token that must be supplied by the
invoker.}

\item{Qualifier}{Specify a version or alias to add permissions to a published version of
the function.}

\item{RevisionId}{Only update the policy if the revision ID matches the ID that's
specified. Use this option to avoid modifying a policy that has changed
since you last read it.}
}
\value{
A list with the following syntax:\preformatted{list(
  Statement = "string"
)
}
}
\description{
Grants an AWS service or another account permission to use a function.
You can apply the policy at the function level, or specify a qualifier
to restrict access to a single version or alias. If you use a qualifier,
the invoker must use the full Amazon Resource Name (ARN) of that version
or alias to invoke the function.

To grant permission to another account, specify the account ID as the
\code{Principal}. For AWS services, the principal is a domain-style
identifier defined by the service, like \code{s3.amazonaws.com} or
\code{sns.amazonaws.com}. For AWS services, you can also specify the ARN of
the associated resource as the \code{SourceArn}. If you grant permission to a
service principal without specifying the source, other accounts could
potentially configure resources in their account to invoke your Lambda
function.

This action adds a statement to a resource-based permissions policy for
the function. For more information about function policies, see \href{https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html}{Lambda Function Policies}.
}
\section{Request syntax}{
\preformatted{svc$add_permission(
  FunctionName = "string",
  StatementId = "string",
  Action = "string",
  Principal = "string",
  SourceArn = "string",
  SourceAccount = "string",
  EventSourceToken = "string",
  Qualifier = "string",
  RevisionId = "string"
)
}
}

\examples{
\dontrun{
# The following example adds permission for Amazon S3 to invoke a Lambda
# function named my-function for notifications from a bucket named
# my-bucket-1xpuxmplzrlbh in account 123456789012.
svc$add_permission(
  Action = "lambda:InvokeFunction",
  FunctionName = "my-function",
  Principal = "s3.amazonaws.com",
  SourceAccount = "123456789012",
  SourceArn = "arn:aws:s3:::my-bucket-1xpuxmplzrlbh/*",
  StatementId = "s3"
)

# The following example adds permission for account 223456789012 invoke a
# Lambda function named my-function.
svc$add_permission(
  Action = "lambda:InvokeFunction",
  FunctionName = "my-function",
  Principal = "223456789012",
  StatementId = "xaccount"
)
}

}
\keyword{internal}
