% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_submit_container_state_change}
\alias{ecs_submit_container_state_change}
\title{This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent}
\usage{
ecs_submit_container_state_change(cluster, task, containerName,
  runtimeId, status, exitCode, reason, networkBindings)
}
\arguments{
\item{cluster}{The short name or full ARN of the cluster that hosts the container.}

\item{task}{The task ID or full Amazon Resource Name (ARN) of the task that hosts
the container.}

\item{containerName}{The name of the container.}

\item{runtimeId}{The ID of the Docker container.}

\item{status}{The status of the state change request.}

\item{exitCode}{The exit code returned for the state change request.}

\item{reason}{The reason for the state change request.}

\item{networkBindings}{The network bindings of the container.}
}
\value{
A list with the following syntax:\preformatted{list(
  acknowledgment = "string"
)
}
}
\description{
This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent.

Sent to acknowledge that a container changed states.
}
\section{Request syntax}{
\preformatted{svc$submit_container_state_change(
  cluster = "string",
  task = "string",
  containerName = "string",
  runtimeId = "string",
  status = "string",
  exitCode = 123,
  reason = "string",
  networkBindings = list(
    list(
      bindIP = "string",
      containerPort = 123,
      hostPort = 123,
      protocol = "tcp"|"udp"
    )
  )
)
}
}

\keyword{internal}
