% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_copy_image}
\alias{ec2_copy_image}
\title{Initiates the copy of an AMI from the specified source Region to the
current Region}
\usage{
ec2_copy_image(ClientToken, Description, Encrypted, KmsKeyId, Name,
  SourceImageId, SourceRegion, DryRun)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Description}{A description for the new AMI in the destination Region.}

\item{Encrypted}{Specifies whether the destination snapshots of the copied image should
be encrypted. You can encrypt a copy of an unencrypted snapshot, but you
cannot create an unencrypted copy of an encrypted snapshot. The default
CMK for EBS is used unless you specify a non-default AWS Key Management
Service (AWS KMS) CMK using \code{KmsKeyId}. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{KmsKeyId}{The identifier of the symmetric AWS Key Management Service (AWS KMS)
customer master key (CMK) to use when creating encrypted volumes. If
this parameter is not specified, your AWS managed CMK for EBS is used.
If you specify a CMK, you must also set the encrypted state to \code{true}.

You can specify a CMK using any of the following:
\itemize{
\item Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
\item Key alias. For example, alias/ExampleAlias.
\item Key ARN. For example,
arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
\item Alias ARN. For example,
arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
}

AWS authenticates the CMK asynchronously. Therefore, if you specify an
identifier that is not valid, the action can appear to complete, but
eventually fails.

The specified CMK must exist in the destination Region.

Amazon EBS does not support asymmetric CMKs.}

\item{Name}{[required] The name of the new AMI in the destination Region.}

\item{SourceImageId}{[required] The ID of the AMI to copy.}

\item{SourceRegion}{[required] The name of the Region that contains the AMI to copy.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ImageId = "string"
)
}
}
\description{
Initiates the copy of an AMI from the specified source Region to the
current Region. You specify the destination Region by using its endpoint
when making the request.

Copies of encrypted backing snapshots for the AMI are encrypted. Copies
of unencrypted backing snapshots remain unencrypted, unless you set
\code{Encrypted} during the copy operation. You cannot create an unencrypted
copy of an encrypted backing snapshot.

For more information about the prerequisites and limits when copying an
AMI, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html}{Copying an AMI}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$copy_image(
  ClientToken = "string",
  Description = "string",
  Encrypted = TRUE|FALSE,
  KmsKeyId = "string",
  Name = "string",
  SourceImageId = "string",
  SourceRegion = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example copies the specified AMI from the us-east-1 region to the
# current region.
svc$copy_image(
  Description = "",
  Name = "My server",
  SourceImageId = "ami-5731123e",
  SourceRegion = "us-east-1"
)
}

}
\keyword{internal}
