% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_domain_entry}
\alias{lightsail_update_domain_entry}
\title{Updates a domain recordset after it is created}
\usage{
lightsail_update_domain_entry(domainName, domainEntry)
}
\arguments{
\item{domainName}{[required] The name of the domain recordset to update.}

\item{domainEntry}{[required] An array of key-value pairs containing information about the domain
entry.}
}
\description{
Updates a domain recordset after it is created.

The \verb{update domain entry} operation supports tag-based access control
via resource tags applied to the resource identified by \verb{domain name}.
For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$update_domain_entry(
  domainName = "string",
  domainEntry = list(
    id = "string",
    name = "string",
    target = "string",
    isAlias = TRUE|FALSE,
    type = "string",
    options = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
