% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_calculate_route_matrix}
\alias{locationservice_calculate_route_matrix}
\title{Calculates a route matrix given the following required parameters:
DeparturePositions and DestinationPositions}
\usage{
locationservice_calculate_route_matrix(
  CalculatorName,
  CarModeOptions = NULL,
  DepartNow = NULL,
  DeparturePositions,
  DepartureTime = NULL,
  DestinationPositions,
  DistanceUnit = NULL,
  Key = NULL,
  TravelMode = NULL,
  TruckModeOptions = NULL
)
}
\arguments{
\item{CalculatorName}{[required] The name of the route calculator resource that you want to use to
calculate the route matrix.}

\item{CarModeOptions}{Specifies route preferences when traveling by \code{Car}, such as avoiding
routes that use ferries or tolls.

Requirements: \code{TravelMode} must be specified as \code{Car}.}

\item{DepartNow}{Sets the time of departure as the current time. Uses the current time to
calculate the route matrix. You can't set both \code{DepartureTime} and
\code{DepartNow}. If neither is set, the best time of day to travel with the
best traffic conditions is used to calculate the route matrix.

Default Value: \code{false}

Valid Values: \code{false} | \code{true}}

\item{DeparturePositions}{[required] The list of departure (origin) positions for the route matrix. An array
of points, each of which is itself a 2-value array defined in \href{https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84}{WGS 84} format:
\verb{[longitude, latitude]}. For example, \verb{[-123.115, 49.285]}.

Depending on the data provider selected in the route calculator resource
there may be additional restrictions on the inputs you can choose. See
\href{https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits}{Position restrictions}
in the \emph{Amazon Location Service Developer Guide}.

For route calculators that use Esri as the data provider, if you specify
a departure that's not located on a road, Amazon Location \href{https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html}{moves the position to the nearest road}.
The snapped value is available in the result in
\code{SnappedDeparturePositions}.

Valid Values: \verb{[-180 to 180,-90 to 90]}}

\item{DepartureTime}{Specifies the desired time of departure. Uses the given time to
calculate the route matrix. You can't set both \code{DepartureTime} and
\code{DepartNow}. If neither is set, the best time of day to travel with the
best traffic conditions is used to calculate the route matrix.

Setting a departure time in the past returns a \verb{400 ValidationException}
error.
\itemize{
\item In \href{https://www.iso.org/iso-8601-date-and-time-format.html}{ISO 8601}
format: \code{YYYY-MM-DDThh:mm:ss.sssZ}. For example,
\verb{2020–07-2T12:15:20.000Z+01:00}
}}

\item{DestinationPositions}{[required] The list of destination positions for the route matrix. An array of
points, each of which is itself a 2-value array defined in \href{https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84}{WGS 84} format:
\verb{[longitude, latitude]}. For example, \verb{[-122.339, 47.615]}

Depending on the data provider selected in the route calculator resource
there may be additional restrictions on the inputs you can choose. See
\href{https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits}{Position restrictions}
in the \emph{Amazon Location Service Developer Guide}.

For route calculators that use Esri as the data provider, if you specify
a destination that's not located on a road, Amazon Location \href{https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html}{moves the position to the nearest road}.
The snapped value is available in the result in
\code{SnappedDestinationPositions}.

Valid Values: \verb{[-180 to 180,-90 to 90]}}

\item{DistanceUnit}{Set the unit system to specify the distance.

Default Value: \code{Kilometers}}

\item{Key}{The optional \href{https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html}{API key}
to authorize the request.}

\item{TravelMode}{Specifies the mode of transport when calculating a route. Used in
estimating the speed of travel and road compatibility.

The \code{TravelMode} you specify also determines how you specify route
preferences:
\itemize{
\item If traveling by \code{Car} use the \code{CarModeOptions} parameter.
\item If traveling by \code{Truck} use the \code{TruckModeOptions} parameter.
}

\code{Bicycle} or \code{Motorcycle} are only valid when using \code{Grab} as a data
provider, and only within Southeast Asia.

\code{Truck} is not available for Grab.

For more information about using Grab as a data provider, see
\href{https://docs.aws.amazon.com/location/latest/developerguide/grab.html}{GrabMaps}
in the \emph{Amazon Location Service Developer Guide}.

Default Value: \code{Car}}

\item{TruckModeOptions}{Specifies route preferences when traveling by \code{Truck}, such as avoiding
routes that use ferries or tolls, and truck specifications to consider
when choosing an optimal road.

Requirements: \code{TravelMode} must be specified as \code{Truck}.}
}
\description{
\href{https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html}{Calculates a route matrix} given the following required parameters: \code{DeparturePositions} and \code{DestinationPositions}. \code{\link[=locationservice_calculate_route_matrix]{calculate_route_matrix}} calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, \code{\link[=locationservice_calculate_route_matrix]{calculate_route_matrix}} will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of \code{DeparturePositions} times the number of \code{DestinationPositions}.

See \url{https://www.paws-r-sdk.com/docs/locationservice_calculate_route_matrix/} for full documentation.
}
\keyword{internal}
