% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_untag_resource}
\alias{sns_untag_resource}
\title{Remove tags from the specified Amazon SNS topic}
\usage{
sns_untag_resource(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The ARN of the topic from which to remove tags.}

\item{TagKeys}{[required] The list of tag keys to remove from the specified topic.}
}
\value{
An empty list.
}
\description{
Remove tags from the specified Amazon SNS topic. For an overview, see
\href{https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html}{Amazon SNS Tags} in the
\emph{Amazon SNS Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
