% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_report_task_progress}
\alias{datapipeline_report_task_progress}
\title{Task runners call ReportTaskProgress when assigned a task to acknowledge
that it has the task}
\usage{
datapipeline_report_task_progress(taskId, fields = NULL)
}
\arguments{
\item{taskId}{[required] The ID of the task assigned to the task runner. This value is provided
in the response for \code{\link[=datapipeline_poll_for_task]{poll_for_task}}.}

\item{fields}{Key-value pairs that define the properties of the
ReportTaskProgressInput object.}
}
\description{
Task runners call \code{\link[=datapipeline_report_task_progress]{report_task_progress}} when assigned a task to acknowledge that it has the task. If the web service does not receive this acknowledgement within 2 minutes, it assigns the task in a subsequent \code{\link[=datapipeline_poll_for_task]{poll_for_task}} call. After this initial acknowledgement, the task runner only needs to report progress every 15 minutes to maintain its ownership of the task. You can change this reporting time from 15 minutes by specifying a \code{reportProgressTimeout} field in your pipeline.

See \url{https://www.paws-r-sdk.com/docs/datapipeline_report_task_progress/} for full documentation.
}
\keyword{internal}
