% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_create_named_query}
\alias{athena_create_named_query}
\title{Creates a named query in the specified workgroup}
\usage{
athena_create_named_query(
  Name,
  Description = NULL,
  Database,
  QueryString,
  ClientRequestToken = NULL,
  WorkGroup = NULL
)
}
\arguments{
\item{Name}{[required] The query name.}

\item{Description}{The query description.}

\item{Database}{[required] The database to which the query belongs.}

\item{QueryString}{[required] The contents of the query with all query statements.}

\item{ClientRequestToken}{A unique case-sensitive string used to ensure the request to create the
query is idempotent (executes only once). If another
\code{\link[=athena_create_named_query]{create_named_query}} request is received,
the same response is returned and another query is not created. If a
parameter has changed, for example, the \code{QueryString}, an error is
returned.

This token is listed as not required because Amazon Web Services SDKs
(for example the Amazon Web Services SDK for Java) auto-generate the
token for users. If you are not using the Amazon Web Services SDK or the
Amazon Web Services CLI, you must provide this token or the action will
fail.}

\item{WorkGroup}{The name of the workgroup in which the named query is being created.}
}
\description{
Creates a named query in the specified workgroup. Requires that you have access to the workgroup.

See \url{https://www.paws-r-sdk.com/docs/athena_create_named_query/} for full documentation.
}
\keyword{internal}
