% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_tables}
\alias{glue_get_tables}
\title{Retrieves the definitions of some or all of the tables in a given
Database}
\usage{
glue_get_tables(
  CatalogId = NULL,
  DatabaseName,
  Expression = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  TransactionId = NULL,
  QueryAsOfTime = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the tables reside. If none is provided,
the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The database in the catalog whose tables to list. For Hive
compatibility, this name is entirely lowercase.}

\item{Expression}{A regular expression pattern. If present, only those tables whose names
match the pattern are returned.}

\item{NextToken}{A continuation token, included if this is a continuation call.}

\item{MaxResults}{The maximum number of tables to return in a single response.}

\item{TransactionId}{The transaction ID at which to read the table contents.}

\item{QueryAsOfTime}{The time as of when to read the table contents. If not set, the most
recent transaction commit time will be used. Cannot be specified along
with \code{TransactionId}.}
}
\description{
Retrieves the definitions of some or all of the tables in a given \code{Database}.

See \url{https://www.paws-r-sdk.com/docs/glue_get_tables/} for full documentation.
}
\keyword{internal}
